/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyDTO;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooTrustedKeyServerKeyVerifier
implements ServerKeyVerifier {
    public static BambooTrustedKeyServerKeyVerifier INSTANCE = new BambooTrustedKeyServerKeyVerifier();
    private static final Logger log = Logger.getLogger(BambooTrustedKeyServerKeyVerifier.class);
    private boolean testMode;

    @VisibleForTesting
    public void setTestMode() {
        this.testMode = true;
    }

    private BambooTrustedKeyServerKeyVerifier() {
    }

    @VisibleForTesting
    @Nullable
    PublicKey parsePublicKey(@NotNull TrustedKey trustedKey) {
        try {
            PublicKeyEntry keyEntry = PublicKeyEntry.parsePublicKeyEntry((String)trustedKey.getKey());
            return keyEntry.resolvePublicKey(null);
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            log.warn((Object)("Could not parse trusted key: " + trustedKey), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private TrustedKey trustedKeyFromPublicKey(@NotNull SocketAddress socketAddress, @NotNull PublicKey publicKey) {
        return new TrustedKeyDTO(socketAddress.toString(), PublicKeyEntry.toString((PublicKey)publicKey));
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        if (this.testMode) {
            return true;
        }
        TrustedKeyHelper trustedKeyHelper = (TrustedKeyHelper)ComponentAccessor.TRUSTED_KEY_HELPER.get();
        if (trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled()) {
            boolean trusted = trustedKeyHelper.getTrustedKeys().stream().filter(TrustedKey::isApproved).map(this::parsePublicKey).filter(Objects::nonNull).anyMatch(pk -> pk.equals(publicKey));
            if (trusted) {
                clientSession.getMetadataMap().remove("bamboo_untrusted_key");
            } else {
                log.info((Object)String.format("Server at [%s] presented an untrusted [%s] key: [%s]", socketAddress, publicKey.getAlgorithm(), KeyUtils.getFingerPrint((PublicKey)publicKey)));
                clientSession.getMetadataMap().put("bamboo_untrusted_key", this.trustedKeyFromPublicKey(socketAddress, publicKey));
            }
            return trusted;
        }
        log.debug((Object)String.format("Server at %s presented unverified %s key: %s", socketAddress, publicKey.getAlgorithm(), KeyUtils.getFingerPrint((PublicKey)publicKey)));
        return true;
    }
}

