/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.plugins.ssh.SshProxy;
import com.atlassian.bamboo.util.Narrow;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClasspathKeyPairProvider
extends AbstractKeyPairProvider {
    private static final String PROXY_SERVER_KEY_PEM = "proxy-server-key.pem";
    private static final String PROXY_SERVER_KEY_LINE = "proxy-server-known-hosts.txt";
    private static final Logger log = Logger.getLogger(ClasspathKeyPairProvider.class);
    private final Iterable<KeyPair> keyPair = ClasspathKeyPairProvider.loadServerKey();

    ClasspathKeyPairProvider() {
    }

    public Iterable<KeyPair> loadKeys() {
        return this.keyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Iterable<KeyPair> loadServerKey() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            log.error((Object)"Bouncycastle not registered, cannot read keys");
            return Collections.emptyList();
        }
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(SshProxy.class.getResourceAsStream(PROXY_SERVER_KEY_PEM)));
        try {
            Object object = pemParser.readObject();
            PEMKeyPair pemKeyPair = (PEMKeyPair)Narrow.downTo((Object)object, PEMKeyPair.class);
            if (pemKeyPair != null) {
                Set<KeyPair> set = Collections.singleton(BouncyCastleProviderUtils.toJavaKeyPair((PEMKeyPair)pemKeyPair));
                return set;
            }
            try {
                throw new IllegalArgumentException("Don't know how to handle proxy-server-key.pem of type " + object.getClass().getCanonicalName());
            }
            catch (IOException e) {
                log.error((Object)"Cannot read host key", (Throwable)e);
                List<KeyPair> list = Collections.emptyList();
                return list;
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)pemParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getKeyKnownHostsLine() {
        InputStream stream = SshProxy.class.getResourceAsStream(PROXY_SERVER_KEY_LINE);
        try {
            List lines = IOUtils.readLines((InputStream)stream);
            if (lines.isEmpty()) {
                log.warn((Object)"known_hosts entry line for key proxy-server-known-hosts.txt is empty");
                String string = null;
                return string;
            }
            String string = (String)lines.get(0);
            return string;
        }
        catch (IOException e) {
            log.warn((Object)"Cannot read known_hosts entry line for key", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

