/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.channel.ChannelDirectTcpip;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.filesystem.NativeFileSystemFactory;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;

public class SshServerBackport {
    static SshServer setUpDefaultServer() {
        SshServer sshd = new SshServer();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG14.Factory(), new DHG1.Factory()));
            sshd.setRandomFactory((Factory)new SingletonRandomFactory((NamedFactory)new JceRandom.Factory()));
        } else {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
            sshd.setRandomFactory((Factory)new SingletonRandomFactory((NamedFactory)new JceRandom.Factory()));
        }
        SshServerBackport.setUpDefaultCiphers(sshd);
        sshd.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        sshd.setMacFactories(Arrays.asList(new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()));
        sshd.setChannelFactories(Arrays.asList(new ChannelSession.Factory(), new ChannelDirectTcpip.Factory()));
        sshd.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
        sshd.setFileSystemFactory((FileSystemFactory)new NativeFileSystemFactory());
        return sshd;
    }

    private static void setUpDefaultCiphers(SshServer sshd) {
        LinkedList<Object> avail = new LinkedList<Object>();
        avail.add(new AES128CBC.Factory());
        avail.add(new TripleDESCBC.Factory());
        avail.add(new BlowfishCBC.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        sshd.setCipherFactories(avail);
    }
}

