/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.github.AbstractGitHubExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubBranchDetector
extends AbstractGitHubExecutor
implements VcsBranchDetector {
    private static final Logger log = Logger.getLogger(GitHubBranchDetector.class);

    @Inject
    public GitHubBranchDetector(VcsRepositoryManager vcsRepositoryManager) {
        super(vcsRepositoryManager);
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return this.getGitBranchDetector().getVcsIdForExecutor(GitHubBranchDetector.githubToGitData(vcsRepositoryData));
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getGitBranchDetector().getOpenBranches(GitHubBranchDetector.githubToGitData(repositoryData));
    }

    @NotNull
    public CommitContext getLastCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getGitBranchDetector().getLastCommit(GitHubBranchDetector.githubToGitData(repositoryData));
    }

    @NotNull
    public CommitContext getFirstCommitApproximation(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getGitBranchDetector().getFirstCommitApproximation(GitHubBranchDetector.githubToGitData(repositoryData));
    }

    @Nullable
    public CommitContext getFirstCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        return this.getGitBranchDetector().getFirstCommit(GitHubBranchDetector.githubToGitData(repositoryData));
    }

    private VcsBranchDetector getGitBranchDetector() {
        return this.getGitModuleDescriptor().getBranchDetector();
    }
}

