[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
    <div id="${id}">
        <p>
            [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
            [/@s.text]
                [#else]
                [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                    [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                [/@s.text]
            [/#if]
        </p>
        <p>
            [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
            [/@s.text]
        </p>
    </div>
    [/@ui.messageBox]
[/#macro]

[@s.textfield labelKey='repository.git.repositoryUrl' name='repository.git.repositoryUrl' longField=true required=true helpKey='git.fields' disabled = true/]

[#assign sharedCredentialsDeleted = stack.findValue('repository.git.sharedCredentials.deleted')!false/]
[#if sharedCredentialsDeleted]
    [#if fn.hasRestrictedAdminPermission()]
        [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
            [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
        <br/>
            [@s.text name="repository.git.sharedCredentials.deleted.update" ]
                [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
            [/@s.text]
        [/@ui.messageBox]
    [#else]
        [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
            [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
        [/@ui.messageBox]
    [/#if]
[#else]
    [#assign defaultSelected='repository.git.authenticationType' /]
[/#if]
[@s.select
    labelKey='repository.git.authenticationType'
    name='repository.git.authenticationType'
    list=gitAuthenticationTypes
    listKey='name'
    listValue='label'
    disabled = true]
[/@s.select]


[#if stack.findValue('repository.git.authenticationType') == 'PASSWORD']
    [@s.radio name='view.repository.git.passwordCredentialsSource'
        value=stack.findValue('repository.git.passwordCredentialsSource')
        listKey='name'
        listValue='label'
        list=passwordCredentialsSources
        descriptionKey='repository.git.passwordCredentialsSource.description'
        cssClass='radio-group'
        disabled = true]
    [/@s.radio]

    [#if stack.findValue('repository.git.passwordCredentialsSource') == 'CUSTOM']
        [@s.textfield labelKey='repository.git.username' name='repository.git.username' disabled=true/]
    [/#if]

    [#if stack.findValue('repository.git.passwordCredentialsSource') == 'SHARED_CREDENTIALS']
        [#if passwordSharedCredentials.empty]
            [@noCredentialsMessageBox id='repository.git.passwordSharedCredentials.infoBox'/]
        [#else]
            [@s.select
                labelKey='repository.git.sharedCredentials'
                name='repository.git.passwordSharedCredentials'
                list=passwordSharedCredentials
                listKey='name'
                listValue='label'
                disabled = true]
            [/@s.select]
        [/#if]
    [/#if]
[/#if]

[#if stack.findValue('repository.git.authenticationType') == 'SSH_KEYPAIR']
    [@s.radio name='view.repository.git.sshCredentialsSource'
        value=stack.findValue('repository.git.sshCredentialsSource')
        listKey='name'
        listValue='label'
        list=sshCredentialsSources
        descriptionKey='repository.git.sshCredentialsSource.description'
        cssClass='radio-group'
        disabled = true]
    [/@s.radio]

    [#if stack.findValue('repository.git.authenticationType') == 'SHARED_CREDENTIALS']
        [#if sshSharedCredentials.empty]
            [@noCredentialsMessageBox id='repository.git.sshSharedCredentials.infoBox'/]
        [#else]
            [@s.select
                labelKey='repository.git.sharedCredentials'
                name='repository.git.sharedCredentials'
                list=sshSharedCredentials
                listKey='name'
                listValue='label'
                disabled = true]
            [/@s.select]
        [/#if]
    [/#if]
[/#if]