[#-- @ftlvariable name="buildConfiguration" type="com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration" --]
[#-- @ftlvariable name="plan" type="com.atlassian.bamboo.plan.Plan" --]
[#-- @ftlvariable name="repository" type="com.atlassian.bamboo.plugins.git.GitRepository" --]
[#macro noCredentialsMessageBox id]
    [@ui.messageBox type='info']
    <div id="${id}">
        <p>
            [#if fn.hasRestrictedAdminPermission()]
                    [@s.text name='sharedCredentials.info.noCredentialsDefined.admin']
                [@s.param][@s.url action='configureSharedCredentials' namespace='/admin/credentials'/][/@s.param]
            [/@s.text]
                [#else]
                [@s.text name='sharedCredentials.info.noCredentialsDefined.nonAdmin']
                    [@s.param][@s.url action='viewAdministrators' namespace=''/][/@s.param]
                [/@s.text]
            [/#if]
        </p>
        <p>
            [@s.text name='sharedCredentials.info.noCredentialsDefined.moreInfo']
                    [@s.param][@help.href pageKey="shared.credentials"/][/@s.param]
                [/@s.text]
        </p>
    </div>
    [/@ui.messageBox]
[/#macro]

[@ui.bambooSection]
    [@s.textfield labelKey='repository.git.repositoryUrl' name='repository.git.repositoryUrl' longField=true disabled=true helpKey='git.fields' /]

    [@s.textfield labelKey='repository.git.branch' name='repository.git.branch' disabled=true/]
    [#if buildConfiguration.getBoolean('repository.git.sharedCredentials.deleted')]
        [#if fn.hasRestrictedAdminPermission()]
            [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
                [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
            <br/>
                [@s.text name="repository.git.sharedCredentials.deleted.update" ]
                    [@s.param][@s.url action="configureSharedCredentials" namespace="/admin" /][/@s.param]
                [/@s.text]
            [/@ui.messageBox]
        [#else]
            [@ui.messageBox type="error" titleKey="repository.git.sharedCredentials.deleted.title"]
                [@s.text name="repository.git.sharedCredentials.deleted.edit"/]
            [/@ui.messageBox]
        [/#if]
    [#else]
        [#assign defaultSelected='repository.git.authenticationType' /]
    [/#if]
    [@s.select
        labelKey='repository.git.authenticationType'
        name='repository.git.authenticationType'
        list=repository.authenticationTypes
        listKey='name'
        listValue='label'
        disabled=true /]

    [#if buildConfiguration.getString('repository.git.authenticationType')=='PASSWORD']

        [@s.radio name='view.repository.git.passwordCredentialsSource'
            value=stack.findValue('repository.git.passwordCredentialsSource')
            listKey='name'
            listValue='label'
            list=repository.passwordCredentialsSources
            descriptionKey='repository.git.passwordCredentialsSource.description'
            cssClass='radio-group'
            disabled =true/]

        [#if buildConfiguration.getString('repository.git.passwordCredentialsSource') =='CUSTOM']
            [@s.textfield labelKey='repository.git.username' name='repository.git.username' disabled = true/]
        [/#if]

        [#if buildConfiguration.getString('repository.git.passwordCredentialsSource') =='SHARED_CREDENTIALS']
            [#if repository.passwordSharedCredentials.empty]
                [@noCredentialsMessageBox id='repository.git.passwordSharedCredentials.infoBox'/]
            [#else]
                [@s.select
                labelKey='repository.git.sharedCredentials'
                name='repository.git.passwordSharedCredentials'
                list=repository.passwordSharedCredentials
                listKey='name'
                listValue='label'
                disabled=true/]
            [/#if]
        [/#if]
    [/#if]

    [#if buildConfiguration.getString('repository.git.authenticationType')=='SSH_KEYPAIR']

        [@s.radio name='view.repository.git.sshCredentialsSource'
            value=stack.findValue('repository.git.sshCredentialsSource')
            listKey='name'
            listValue='label'
            list=repository.sshCredentialsSources
            descriptionKey='repository.git.sshCredentialsSource.description'
            cssClass='radio-group'
            disabled=true/]

        [#if buildConfiguration.getString('repository.git.sshCredentialsSource') =='SHARED_CREDENTIALS']
            [#if repository.sshSharedCredentials.empty]
                [@noCredentialsMessageBox id='repository.git.sshSharedCredentials.infoBox'/]
            [#else]
                [@s.select
                    labelKey='repository.git.sharedCredentials'
                    name='repository.git.sharedCredentials'
                    list=repository.sshSharedCredentials
                    listKey='name'
                    listValue='label'
                    disabled=true/]
            [/#if]
        [/#if]
    [/#if]
[/@ui.bambooSection]