/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github;

import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AbstractGitHubExecutor {
    private static final Logger log = Logger.getLogger(AbstractGitHubExecutor.class);
    protected final VcsRepositoryManager vcsRepositoryManager;

    public AbstractGitHubExecutor(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    protected VcsRepositoryModuleDescriptor getGitModuleDescriptor() {
        return this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2");
    }

    public static VcsRepositoryData githubToGitData(@NotNull VcsRepositoryData vcsRepositoryData) {
        Map<String, String> gitServerConfiguration = AbstractGitHubExecutor.transformToGitServerCfg(vcsRepositoryData.getVcsLocation().getConfiguration());
        Map<String, String> gitBranchConfiguration = AbstractGitHubExecutor.transformToGitBranchCfg(vcsRepositoryData.getBranch().getConfiguration());
        PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().vcsBranch(vcsRepositoryData.getBranch().getVcsBranch()).changeDetectionConfiguration(vcsRepositoryData.getVcsChangeDetectionOptions().getConfiguration()).name(vcsRepositoryData.getName()).description(vcsRepositoryData.getDescription()).pluginKey("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2").serverConfiguration(gitServerConfiguration).branchConfiguration(gitBranchConfiguration);
        return builder.build().getCompleteData();
    }

    private static Map<String, String> transformToGitServerCfg(Map<String, String> configuration) {
        HashMap<String, String> gitConfig = new HashMap<String, String>();
        gitConfig.put("repository.git.repositoryUrl", UrlUtils.appendSlashIfDoesntExist((String)configuration.getOrDefault("repository.github.baseUrl", "https://github.com/")).trim() + configuration.get("repository.github.repository").trim() + ".git");
        gitConfig.put("repository.git.authenticationType", GitAuthenticationType.PASSWORD.name());
        gitConfig.put("repository.git.username", configuration.get("repository.github.username"));
        gitConfig.put("repository.git.password", configuration.get("repository.github.password"));
        gitConfig.put("repository.git.commandTimeout", StringUtils.defaultString((String)configuration.get("repository.github.commandTimeout"), (String)Integer.toString(180)));
        gitConfig.put("repository.git.verbose.logs", configuration.get("repository.github.verbose.logs"));
        gitConfig.put("repository.git.useShallowClones", configuration.get("repository.github.useShallowClones"));
        gitConfig.put("repository.git.useSubmodules", configuration.get("repository.github.useSubmodules"));
        gitConfig.put("repository.git.useRemoteAgentCache", configuration.get("repository.github.useRemoteAgentCache"));
        gitConfig.put("repository.git.fetch.whole.repository", configuration.get("repository.github.fetch.whole.repository"));
        gitConfig.put("repository.git.lfs", configuration.get("repository.github.lfs"));
        return gitConfig;
    }

    private static Map<String, String> transformToGitBranchCfg(Map<String, String> configuration) {
        HashMap<String, String> gitConfig = new HashMap<String, String>();
        gitConfig.put("repository.git.branch", (String)StringUtils.defaultIfBlank((CharSequence)configuration.get("repository.github.branch"), (CharSequence)"master"));
        return gitConfig;
    }
}

