/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.domain;

import com.atlassian.bamboo.plugins.git.api.GitRef;
import org.jetbrains.annotations.Nullable;

public final class HashAndSource {
    private GitRef ref;
    private String branch;
    private final String hash;

    private HashAndSource(String hash) {
        this.hash = hash;
    }

    @Nullable
    public String getRefValue() {
        return this.ref == null ? null : this.ref.getValue();
    }

    @Nullable
    public GitRef getRef() {
        return this.ref;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public String getHash() {
        return this.hash;
    }

    public static HashAndSource hashAndBranch(String revHash, String branch) {
        HashAndSource hashAndSource = new HashAndSource(revHash);
        hashAndSource.branch = branch;
        return hashAndSource;
    }

    public static HashAndSource hashAndRef(String revHash, String ref) {
        HashAndSource hashAndSource = new HashAndSource(revHash);
        hashAndSource.ref = new GitRef(ref);
        return hashAndSource;
    }

    public String toString() {
        return "HashAndSource{refName=[" + this.ref + ']' + ", branch=[" + this.branch + ']' + ", hash=[" + this.hash + "]}";
    }
}

