/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.exporter;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.builders.repository.git.GitRepository;
import com.atlassian.bamboo.specs.builders.repository.git.SshPrivateKeyAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.GitRepositoryProperties;
import com.atlassian.bamboo.specs.model.repository.git.SharedCredentialsAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SshPrivateKeyAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class GitConfigurationExporter
implements VcsRepositoryDataExporter<GitRepository, GitRepositoryProperties> {
    @Autowired
    private CredentialsAccessor credentialsAccessor;
    @Autowired
    private I18nResolver i18nResolver;
    private final ValidationContext validationContext = ValidationContext.of((String)"Git repository");

    @NotNull
    public GitRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData vcsRepositoryData) {
        return new GitRepository();
    }

    @NotNull
    public GitRepository appendLocationData(@NotNull GitRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        Map configuration = vcsLocationDefinition.getConfiguration();
        int commandTimeout = configuration.containsKey("repository.git.commandTimeout") ? Integer.valueOf((String)configuration.get("repository.git.commandTimeout")) : 180;
        GitRepository gitRepository = builder.url((String)configuration.get("repository.git.repositoryUrl")).shallowClonesEnabled(Boolean.valueOf((String)configuration.get("repository.git.useShallowClones")).booleanValue()).submodulesEnabled(Boolean.valueOf((String)configuration.get("repository.git.useSubmodules")).booleanValue()).remoteAgentCacheEnabled(Boolean.valueOf((String)configuration.get("repository.git.useRemoteAgentCache")).booleanValue()).commandTimeout(Duration.ofMinutes(commandTimeout)).verboseLogs(Boolean.valueOf((String)configuration.get("repository.git.verbose.logs")).booleanValue()).fetchWholeRepository(Boolean.valueOf((String)configuration.get("repository.git.fetch.whole.repository")).booleanValue()).lfsEnabled(Boolean.valueOf((String)configuration.get("repository.git.lfs")).booleanValue());
        String chosenAuthentication = (String)configuration.get("repository.git.authenticationType");
        GitAuthenticationType authenticationType = chosenAuthentication != null ? GitAuthenticationType.valueOf(chosenAuthentication) : GitAuthenticationType.NONE;
        block0 : switch (authenticationType) {
            case NONE: {
                break;
            }
            case PASSWORD: {
                String passwordCredentialsSource = (String)configuration.get("repository.git.passwordCredentialsSource");
                switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSource)) {
                    case SHARED_CREDENTIALS: {
                        int sharedCredentialsId = Integer.valueOf((String)configuration.get("repository.git.passwordSharedCredentials"));
                        CredentialsData credentials = this.credentialsAccessor.getCredentials((long)sharedCredentialsId);
                        if (credentials == null) {
                            throw new RuntimeException(String.format("Shared credentials not found id=%d", sharedCredentialsId));
                        }
                        SharedCredentialsIdentifier sharedCredentialsIdentifier = new SharedCredentialsIdentifier(credentials.getName()).oid(credentials.getOid().toExternalValue());
                        gitRepository.authentication(sharedCredentialsIdentifier);
                        break;
                    }
                    case CUSTOM: {
                        String username = (String)configuration.get("repository.git.username");
                        UserPasswordAuthentication userPasswordAuthentication = new UserPasswordAuthentication(username).password((String)configuration.get("repository.git.password"));
                        gitRepository.authentication(userPasswordAuthentication);
                    }
                }
                break;
            }
            case SSH_KEYPAIR: {
                String sshCredentialsSource = (String)configuration.get("repository.git.sshCredentialsSource");
                switch (GitSshCredentialsSource.valueOf(sshCredentialsSource)) {
                    case SHARED_CREDENTIALS: {
                        int sharedCredentialsId = Integer.valueOf((String)configuration.get("repository.git.sharedCredentials"));
                        CredentialsData credentials = this.credentialsAccessor.getCredentials((long)sharedCredentialsId);
                        if (credentials == null) {
                            throw new RuntimeException(String.format("Shared credentials not found id=%d", sharedCredentialsId));
                        }
                        SharedCredentialsIdentifier sharedCredentialsIdentifier = new SharedCredentialsIdentifier(credentials.getName()).oid(credentials.getOid().toExternalValue());
                        gitRepository.authentication(sharedCredentialsIdentifier);
                        break block0;
                    }
                    case CUSTOM: {
                        SshPrivateKeyAuthentication sshPrivateKeyAuthentication = new SshPrivateKeyAuthentication((String)configuration.get("repository.git.ssh.key")).passphrase((String)configuration.get("repository.git.ssh.passphrase"));
                        gitRepository.authentication(sshPrivateKeyAuthentication);
                    }
                }
            }
        }
        return gitRepository;
    }

    @NotNull
    public GitRepository appendBranchData(@NotNull GitRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder.branch((String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)vcsBranchDefinition.getConfiguration().get("repository.git.branch")), (CharSequence)"master"));
    }

    @NotNull
    public GitRepository appendChangeDetectionOptions(@NotNull GitRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        builder.changeDetection(DefaultVcsRepositoryDataExporter.exportStandardChangeDetectionOptions((VcsChangeDetectionOptions)changeDetectionOptions));
        return builder;
    }

    @NotNull
    public GitRepository appendBranchDetectionOptions(@NotNull GitRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder;
    }

    @Nullable
    public Map<String, String> importLocationData(@NotNull GitRepositoryProperties repositoryProperties, @Nullable VcsLocationDefinition existingData) {
        if (repositoryProperties.getUrl() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.git.repositoryUrl", repositoryProperties.getUrl());
            configuration.put("repository.git.useShallowClones", Boolean.toString(repositoryProperties.isUseShallowClones()));
            configuration.put("repository.git.useRemoteAgentCache", Boolean.toString(repositoryProperties.isUseRemoteAgentCache()));
            configuration.put("repository.git.useSubmodules", Boolean.toString(repositoryProperties.isUseSubmodules()));
            configuration.put("repository.git.commandTimeout", Long.toString(repositoryProperties.getCommandTimeout().toMinutes()));
            configuration.put("repository.git.verbose.logs", Boolean.toString(repositoryProperties.isVerboseLogs()));
            configuration.put("repository.git.fetch.whole.repository", Boolean.toString(repositoryProperties.isFetchWholeRepository()));
            configuration.put("repository.git.lfs", Boolean.toString(repositoryProperties.isUseLfs()));
            AuthenticationProperties authenticationProperties = repositoryProperties.getAuthenticationProperties();
            if (authenticationProperties != null) {
                if (authenticationProperties instanceof SharedCredentialsAuthenticationProperties) {
                    SharedCredentialsAuthenticationProperties sharedCredentialsAuthenticationProperties = (SharedCredentialsAuthenticationProperties)Narrow.to((Object)authenticationProperties, SharedCredentialsAuthenticationProperties.class);
                    CredentialsData credentials = this.findCredentialByOidOrName(sharedCredentialsAuthenticationProperties.getSharedCredentials());
                    if (credentials == null) {
                        throw new PropertiesValidationException("Referenced credential not found: " + sharedCredentialsAuthenticationProperties.getSharedCredentials());
                    }
                    switch (credentials.getPluginKey()) {
                        case "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials": {
                            configuration.put("repository.git.authenticationType", GitAuthenticationType.PASSWORD.name());
                            configuration.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.SHARED_CREDENTIALS.name());
                            configuration.put("repository.git.passwordSharedCredentials", String.valueOf(credentials.getId()));
                            break;
                        }
                        case "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials": {
                            configuration.put("repository.git.authenticationType", GitAuthenticationType.SSH_KEYPAIR.name());
                            configuration.put("repository.git.sshCredentialsSource", GitSshCredentialsSource.SHARED_CREDENTIALS.name());
                            configuration.put("repository.git.sharedCredentials", String.valueOf(credentials.getId()));
                            break;
                        }
                        default: {
                            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("Git repository: unsupported shared credentials type " + credentials.getPluginKey())));
                        }
                    }
                } else if (authenticationProperties instanceof SshPrivateKeyAuthenticationProperties) {
                    SshPrivateKeyAuthenticationProperties sshPrivateKeyAuthenticationProperties = (SshPrivateKeyAuthenticationProperties)Narrow.to((Object)authenticationProperties, SshPrivateKeyAuthenticationProperties.class);
                    configuration.put("repository.git.authenticationType", GitAuthenticationType.SSH_KEYPAIR.name());
                    configuration.put("repository.git.sshCredentialsSource", GitSshCredentialsSource.CUSTOM.name());
                    configuration.put("repository.git.ssh.key", sshPrivateKeyAuthenticationProperties.getSshPrivateKey());
                    configuration.put("repository.git.ssh.passphrase", StringUtils.defaultString((String)sshPrivateKeyAuthenticationProperties.getPassphrase()));
                } else if (authenticationProperties instanceof UserPasswordAuthenticationProperties) {
                    UserPasswordAuthenticationProperties userPasswordAuthenticationProperties = (UserPasswordAuthenticationProperties)Narrow.to((Object)authenticationProperties, UserPasswordAuthenticationProperties.class);
                    configuration.put("repository.git.authenticationType", GitAuthenticationType.PASSWORD.name());
                    configuration.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
                    configuration.put("repository.git.username", userPasswordAuthenticationProperties.getUsername());
                    configuration.put("repository.git.password", StringUtils.defaultString((String)userPasswordAuthenticationProperties.getPassword()));
                }
            } else {
                configuration.put("repository.git.authenticationType", GitAuthenticationType.NONE.name());
            }
            List<ValidationProblem> problems = this.validateLocationData(configuration);
            if (!problems.isEmpty()) {
                throw new PropertiesValidationException(problems);
            }
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("Git server data not defined or incomplete")));
        }
        return null;
    }

    @Nullable
    private CredentialsData findCredentialByOidOrName(SharedCredentialsIdentifierProperties sharedCredentials) {
        BambooOidProperties sharedCredentialsOid = sharedCredentials.getOid();
        if (sharedCredentials.getOid() != null) {
            return this.credentialsAccessor.getCredentialsByOid(BambooEntityOid.createFromExternalValue((String)sharedCredentialsOid.getOid()));
        }
        return this.credentialsAccessor.getCredentialsByName(sharedCredentials.getName());
    }

    @Nullable
    public Map<String, String> importBranchData(@NotNull GitRepositoryProperties repositoryProperties, @Nullable VcsBranchDefinition existingData) {
        if (repositoryProperties.getBranch() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.git.branch", repositoryProperties.getBranch());
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("Git branch not defined")));
        }
        return null;
    }

    @Nullable
    public Map<String, String> importChangeDetectionOptions(@NotNull GitRepositoryProperties repositoryProperties, @Nullable VcsChangeDetectionOptions existingData) {
        return DefaultVcsRepositoryDataExporter.importStandardChangeDetectionOptions((VcsRepositoryProperties)repositoryProperties, (VcsChangeDetectionProperties)repositoryProperties.getVcsChangeDetection());
    }

    @Nullable
    public Map<String, String> importBranchDetectionOptions(@NotNull GitRepositoryProperties repositoryProperties, @Nullable VcsBranchDetectionOptions existingData) {
        return null;
    }

    @NotNull
    private List<ValidationProblem> validateLocationData(@NotNull Map<String, String> configuration) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        String url = configuration.get("repository.git.repositoryUrl");
        if (url != null && !ValidationUtils.containsBambooVariable((String)url)) {
            GitAuthenticationType authenticationType;
            String chosenAuthentication = configuration.get("repository.git.authenticationType");
            ValidationUtils.validateRequiredEnum((ValidationContext)this.validationContext.with("authenticationType"), (String)chosenAuthentication, GitAuthenticationType.class).ifPresent(errors::add);
            GitAuthenticationType gitAuthenticationType = authenticationType = chosenAuthentication != null ? GitAuthenticationType.valueOf(chosenAuthentication) : null;
            if (authenticationType != null) {
                try {
                    URIish repositoryUri = new URIish(url);
                    String scheme = repositoryUri.getScheme();
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
                        if ("http".equals(scheme) || "https".equals(scheme)) {
                            errors.add(new ValidationProblem(this.i18nResolver.getText("repository.git.messages.unsupportedHttpAuthenticationType")));
                        }
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        boolean duplicatePassword;
                        GitPasswordCredentialsSource passwordCredentialsSource = GitPasswordCredentialsSource.valueOf(configuration.get("repository.git.passwordCredentialsSource"));
                        boolean hasUsername = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)configuration.get("repository.git.username"));
                        boolean hasPassword = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)configuration.get("repository.git.password"));
                        boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((CharSequence)repositoryUri.getUser());
                        boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((CharSequence)repositoryUri.getPass());
                        if (duplicateUsername) {
                            errors.add(new ValidationProblem(this.i18nResolver.getText("repository.git.messages.duplicateUsernameField")));
                        }
                        if (duplicatePassword) {
                            errors.add(new ValidationProblem(this.i18nResolver.getText("repository.git.messages.duplicatePasswordField")));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    errors.add(new ValidationProblem(this.i18nResolver.getText("repository.git.messages.invalidURI", new Serializable[]{url})));
                }
            }
        }
        return errors;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }
}

