/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class GitHubServerConfigurator
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(GitHubServerConfigurator.class);
    @Autowired
    private I18nResolver i18nResolver;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put("repository.github.commandTimeout", 180);
        context.put("repository.github.useRemoteAgentCache", true);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        context.put("repository.github.repository", cfg.getOrDefault("repository.github.repository", "").trim());
        context.put("repository.github.username", cfg.getOrDefault("repository.github.username", "").trim());
        this.putDummyIfValueIsNotBlank(context, cfg, "repository.github.password");
        context.put("repository.github.commandTimeout", cfg.getOrDefault("repository.github.commandTimeout", Integer.toString(180)).trim());
        context.put("repository.github.verbose.logs", cfg.get("repository.github.verbose.logs"));
        context.put("repository.github.useShallowClones", Boolean.valueOf((String)cfg.get("repository.github.useShallowClones")));
        context.put("repository.github.useSubmodules", cfg.get("repository.github.useSubmodules"));
        context.put("repository.github.useRemoteAgentCache", cfg.get("repository.github.useRemoteAgentCache"));
        context.put("repository.github.fetch.whole.repository", cfg.get("repository.github.fetch.whole.repository"));
        context.put("repository.github.lfs", cfg.getOrDefault("repository.github.lfs", "false"));
    }

    private void putDummyIfValueIsNotBlank(@NotNull Map<String, Object> context, @NotNull Map<String, String> cfg, String key) {
        if (StringUtils.isNotBlank((CharSequence)cfg.get(key))) {
            context.put(key, "dummy");
        }
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isBlank((CharSequence)actionParametersMap.getString("repository.github.repository"))) {
            errorCollection.addError("repository.github.repository", this.i18nResolver.getText("repository.github.error.missingRepository"));
        }
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition) {
        HashMap cfgMap = Maps.newHashMap();
        if (previousVcsLocationDefinition != null) {
            cfgMap.putAll(previousVcsLocationDefinition.getConfiguration());
        }
        cfgMap.put("repository.github.repository", actionParametersMap.getString("repository.github.repository"));
        cfgMap.put("repository.github.username", actionParametersMap.getString("repository.github.username"));
        if (actionParametersMap.getBoolean("temporary.github.password.change")) {
            cfgMap.put("repository.github.password", actionParametersMap.getString("repository.github.temporary.password"));
        }
        cfgMap.put("repository.github.commandTimeout", Integer.toString(actionParametersMap.getInt("repository.github.commandTimeout", 180)));
        cfgMap.put("repository.github.verbose.logs", Boolean.toString(actionParametersMap.getBoolean("repository.github.verbose.logs")));
        cfgMap.put("repository.github.useShallowClones", Boolean.toString(actionParametersMap.getBoolean("repository.github.useShallowClones")));
        cfgMap.put("repository.github.useSubmodules", Boolean.toString(actionParametersMap.getBoolean("repository.github.useSubmodules")));
        cfgMap.put("repository.github.useRemoteAgentCache", Boolean.toString(actionParametersMap.getBoolean("repository.github.useRemoteAgentCache")));
        cfgMap.put("repository.github.fetch.whole.repository", Boolean.toString(actionParametersMap.getBoolean("repository.github.fetch.whole.repository")));
        cfgMap.put("repository.github.lfs", Boolean.toString(actionParametersMap.getBoolean("repository.github.lfs")));
        return cfgMap;
    }

    public void addDefaultsForAdvancedOptions(@NotNull Map<String, String> cfgMap) {
        cfgMap.put("repository.github.commandTimeout", Integer.toString(180));
        cfgMap.put("repository.github.useRemoteAgentCache", Boolean.TRUE.toString());
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        try {
            return new URL("https://github.com/").getHost();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return "https://github.com/" + ((String)vcsLocationDefinition.getConfiguration().get("repository.github.repository")).trim() + ".git";
    }

    public Optional<VcsType> getScmType(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return Optional.of(VcsType.GIT);
    }
}

