/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.HostNameNonSensitiveHostKeyRepository;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.Nullable;

public class GitSshSessionFactory
extends JschConfigSessionFactory {
    @Nullable
    private final String key;
    @Nullable
    private final String passphrase;
    private final TrustedKeyHelper trustedKeysHelper;

    GitSshSessionFactory(GitSshSessionFactory factory) {
        this(factory.key, factory.passphrase, factory.trustedKeysHelper);
    }

    GitSshSessionFactory(@Nullable String key, @Nullable String passphrase, TrustedKeyHelper trustedKeysHelper) {
        this.key = key;
        this.passphrase = passphrase;
        this.trustedKeysHelper = trustedKeysHelper;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        String enableStrictHostKeyCheck = this.trustedKeysHelper.isCustomAcceptedSshHostKeysEnabled() ? "yes" : "no";
        session.setConfig("StrictHostKeyChecking", enableStrictHostKeyCheck);
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        JSch jsch = super.getJSch(hc, fs);
        jsch.removeAllIdentity();
        if (StringUtils.isNotEmpty((CharSequence)this.key)) {
            jsch.addIdentity("identityName", this.key.getBytes(), null, StringUtils.defaultString((String)this.passphrase).getBytes());
        }
        if (this.trustedKeysHelper.isCustomAcceptedSshHostKeysEnabled()) {
            this.updateHostKeyRepository(jsch);
        }
        return jsch;
    }

    private void updateHostKeyRepository(JSch jsch) throws JSchException {
        jsch.setKnownHosts(this.trustedKeysHelper.getCustomAcceptedSshHostKeysFile().getAbsolutePath());
        jsch.setHostKeyRepository((HostKeyRepository)new HostNameNonSensitiveHostKeyRepository(jsch.getHostKeyRepository()));
    }
}

