/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitHubAccessor;
import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoadGitHubRepositories
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(LoadGitHubRepositories.class);
    private String username;
    private String password;
    private long repositoryId;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private EncryptionService encryptionService;

    public String doLoad() throws Exception {
        return "success";
    }

    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        RepositoryDataImpl repositoryDefinition;
        Repository repository;
        GitHubRepository ghRepository;
        RepositoryDataEntity repositoryDataEntity;
        Map<String, Iterable<String>> gitHubRepositories = null;
        if (this.repositoryId > 0L && StringUtils.isBlank((String)this.password) && (repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(this.repositoryId)) != null && (ghRepository = (GitHubRepository)((Object)Narrow.to((Object)(repository = (repositoryDefinition = new RepositoryDataImpl(repositoryDataEntity)).getRepository()), GitHubRepository.class))) != null) {
            this.password = this.encryptionService.decrypt(ghRepository.getEncryptedPassword());
        }
        if (StringUtils.isBlank((String)this.username)) {
            this.addFieldError("username", this.getText("repository.github.error.emptyUsername"));
        }
        this.checkFieldXssSafety("username", this.username);
        if (this.hasErrors()) {
            return super.getJsonObject();
        }
        try {
            gitHubRepositories = this.getGitHubRepositoresAndBranches();
        }
        catch (GitHubAccessor.GitHubException e) {
            if (e.isAuthError()) {
                if (this.getPlan() != null) {
                    this.addFieldError("username", this.getText("repository.github.error.notAuthorized"));
                } else {
                    this.addFieldError("temporary.password", this.getText("repository.github.error.notAuthorized"));
                }
            } else {
                this.addActionError(this.getText("repository.github.ajaxError") + e.toString());
                log.error((Object)("Could not load github repositories for " + this.username + "."), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("repository.github.ajaxError") + e.toString());
            log.error((Object)("Could not load github repositories for " + this.username + "."), (Throwable)e);
        }
        JSONObject jsonObject = super.getJsonObject();
        if (this.hasErrors()) {
            return jsonObject;
        }
        assert (gitHubRepositories != null);
        ArrayList data = Lists.newArrayList();
        for (Map.Entry<String, Iterable<String>> entry : gitHubRepositories.entrySet()) {
            String repository2 = entry.getKey();
            for (String branch : entry.getValue()) {
                data.add(new JSONObject().put("value", (Object)branch).put("text", (Object)branch).put("supportedValues", (Object)new String[]{repository2}));
            }
        }
        jsonObject.put("repositoryBranchFilter", (Object)new JSONObject().put("data", (Collection)data));
        jsonObject.put("gitHubRepositories", (Object)this.newJsonLinkedHashMap(gitHubRepositories));
        return jsonObject;
    }

    private JSONObject newJsonLinkedHashMap(Map<String, Iterable<String>> gitHubRepositories) throws JSONException {
        JSONObject map = new JSONObject();
        for (Map.Entry<String, Iterable<String>> entry : gitHubRepositories.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @NotNull
    private Map<String, Iterable<String>> getGitHubRepositoresAndBranches() throws IOException, GitHubAccessor.GitHubException {
        GitHubAccessor gitHubAccessor = new GitHubAccessor(this.username, this.password);
        Map<String, Iterable<String>> accessibleRepositoriesAndBranches = gitHubAccessor.getAccessibleRepositoriesAndBranches();
        if (accessibleRepositoriesAndBranches.isEmpty()) {
            this.addFieldError("username", this.getText("repository.github.error.noRepositories", Arrays.asList(this.username)));
        }
        return accessibleRepositoriesAndBranches;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }
}

