/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.exporter;

import com.atlassian.bamboo.configuration.external.helpers.StringExportHelper;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.importer.common.ValidationProblem;
import com.atlassian.bamboo.importer.common.ValidationUtils;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class GitConfigurationExporter
implements VcsRepositoryDataExporter {
    private static final Set<String> SUPPORTED_SCHEMES = Sets.newHashSet((Object[])new String[]{"http", "https", "ssh", "file", null});
    private static final ImmutableMap<String, EnumSet<GitAuthenticationType>> SUPPORTED_AUTH_TYPES = ImmutableMap.of((Object)"http", EnumSet.of(GitAuthenticationType.PASSWORD, GitAuthenticationType.NONE), (Object)"https", EnumSet.of(GitAuthenticationType.PASSWORD, GitAuthenticationType.NONE), (Object)"ssh", EnumSet.of(GitAuthenticationType.PASSWORD, GitAuthenticationType.SSH_KEYPAIR, GitAuthenticationType.NONE));
    private static Set<String> exportKeysToSkip = ImmutableSet.of((Object)"repository.git.sharedCredentials", (Object)"repository.git.passwordSharedCredentials");
    private static Set<String> importKeysToSkip = ImmutableSet.of((Object)"sshSharedCredentials", (Object)"passwordSharedCredentials");
    @Autowired
    private CredentialsAccessor credentialsAccessor;

    private String getCredentialRef(@NotNull String key, @NotNull Map<String, String> configuration) {
        String credentialKey = configuration.get(key);
        CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(credentialKey));
        if (credentials != null) {
            return credentials.getOid().toExternalValue();
        }
        throw new RuntimeException("unknownCredentials");
    }

    private String removePrefix(String key) {
        return key.substring("repository.git.".length());
    }

    private String addPrefix(String key) {
        return "repository.git." + key;
    }

    @NotNull
    public Map<String, Object> exportLocationData(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Map configuration = vcsLocationDefinition.getConfiguration();
        configuration.entrySet().stream().filter(e -> !exportKeysToSkip.contains(e.getKey())).sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey())).forEach(e -> data.put(this.removePrefix((String)e.getKey()), StringExportHelper.getObjectValue((String)((String)e.getValue()))));
        if (GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(configuration.get("repository.git.sshCredentialsSource"))) {
            data.put("sshSharedCredentials", this.getCredentialRef("repository.git.sharedCredentials", configuration));
        }
        if (GitPasswordCredentialsSource.SHARED_CREDENTIALS.name().equals(configuration.get("repository.git.passwordCredentialsSource"))) {
            data.put("passwordSharedCredentials", this.getCredentialRef("repository.git.passwordSharedCredentials", configuration));
        }
        return data;
    }

    @NotNull
    public Map<String, String> importLocationData(@NotNull Map<String, Object> configurationMap) {
        String oid;
        CredentialsData credentials;
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        configurationMap.entrySet().stream().filter(e -> !importKeysToSkip.contains(e.getKey())).forEach(e -> configuration.put(this.addPrefix((String)e.getKey()), e.getValue().toString()));
        if (configurationMap.containsKey("sshSharedCredentials")) {
            String oid2 = configurationMap.get("sshSharedCredentials").toString();
            CredentialsData credentials2 = this.credentialsAccessor.getCredentialsByOid(BambooEntityOid.createFromExternalValue((String)oid2));
            if (credentials2 != null) {
                configuration.put("repository.git.sharedCredentials", String.valueOf(credentials2.getId()));
            }
        } else if (configurationMap.containsKey("passwordSharedCredentials") && (credentials = this.credentialsAccessor.getCredentialsByOid(BambooEntityOid.createFromExternalValue((String)(oid = configurationMap.get("passwordSharedCredentials").toString())))) != null) {
            configuration.put("repository.git.passwordSharedCredentials", String.valueOf(credentials.getId()));
        }
        if (!configurationMap.containsKey("repository.git.commandTimeout")) {
            configuration.put("repository.git.commandTimeout", Integer.toString(180));
        }
        if (!configurationMap.containsKey("repository.git.useShallowClones")) {
            configuration.put("repository.git.useShallowClones", Boolean.TRUE.toString());
        }
        return configuration;
    }

    private void checkSimpleProperties(@NotNull Map<String, String> configuration, List<ValidationProblem> errors) {
        ValidationUtils.checkRequiredString((String)configuration.get("repository.git.repositoryUrl"), (String)"Git repository - URL").ifPresent(errors::add);
        ValidationUtils.checkRequiredBoolean((String)configuration.get("repository.git.useShallowClones"), (String)"Git repository - useShallowCloned").ifPresent(errors::add);
        ValidationUtils.checkRequiredBoolean((String)configuration.get("repository.git.useRemoteAgentCache"), (String)"Git repository - useRemoteAgentCache").ifPresent(errors::add);
        ValidationUtils.checkRequiredBoolean((String)configuration.get("repository.git.useSubmodules"), (String)"Git repository - useSubmodules").ifPresent(errors::add);
        ValidationUtils.checkRequiredLong((String)configuration.get("repository.git.commandTimeout"), (String)"Git repository - commandTimeout").ifPresent(errors::add);
        ValidationUtils.checkRequiredBoolean((String)configuration.get("repository.git.verbose.logs"), (String)"Git repository - verboseLogs").ifPresent(errors::add);
        ValidationUtils.checkRequiredString((String)configuration.get("repository.git.fetch.whole.repository"), (String)"Git repository - fetchWholeRepository").ifPresent(errors::add);
        ValidationUtils.checkBoolean((String)configuration.get("repository.git.lfs"), (String)"Git repository - lfsRepository").ifPresent(errors::add);
    }

    @NotNull
    public List<ValidationProblem> validateLocationData(@NotNull Map<String, String> configuration) {
        String url;
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        this.checkSimpleProperties(configuration, errors);
        String chosenAuthentication = configuration.get("repository.git.authenticationType");
        ValidationUtils.checkRequiredEnum((String)chosenAuthentication, GitAuthenticationType.class, (String)"Git repository - authenticationType").ifPresent(errors::add);
        GitAuthenticationType authenticationType = chosenAuthentication != null ? GitAuthenticationType.valueOf(chosenAuthentication) : null;
        String username = configuration.get("repository.git.username");
        if (authenticationType != null) {
            block1 : switch (authenticationType) {
                case NONE: {
                    break;
                }
                case PASSWORD: {
                    String passwordCredentialsSource = configuration.get("repository.git.passwordCredentialsSource");
                    ValidationUtils.checkRequiredEnum((String)passwordCredentialsSource, GitPasswordCredentialsSource.class, (String)"Git repository - passwordCredentialsSource").ifPresent(errors::add);
                    switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSource)) {
                        case SHARED_CREDENTIALS: {
                            ValidationUtils.checkRequiredString((String)configuration.get("repository.git.passwordSharedCredentials"), (String)"Git repository - passwordCredentialsId").ifPresent(errors::add);
                            break;
                        }
                        case CUSTOM: {
                            ValidationUtils.checkRequiredString((String)username, (String)"Git repository - username").ifPresent(errors::add);
                            ValidationUtils.checkRequiredString((String)configuration.get("repository.git.password"), (String)"Git repository - password").ifPresent(errors::add);
                        }
                    }
                    break;
                }
                case SSH_KEYPAIR: {
                    String sshCredentialsSource = configuration.get("repository.git.sshCredentialsSource");
                    ValidationUtils.checkRequiredEnum((String)sshCredentialsSource, GitSshCredentialsSource.class, (String)"Git repository - sshCredentialsSource").ifPresent(errors::add);
                    switch (GitSshCredentialsSource.valueOf(sshCredentialsSource)) {
                        case SHARED_CREDENTIALS: {
                            ValidationUtils.checkRequiredString((String)configuration.get("repository.git.sharedCredentials"), (String)"Git repository - sshSharedCredentialsId").ifPresent(errors::add);
                            break block1;
                        }
                        case CUSTOM: {
                            ValidationUtils.checkRequiredString((String)configuration.get("repository.git.ssh.key"), (String)"Git repository - key").ifPresent(errors::add);
                            ValidationUtils.checkRequiredString((String)configuration.get("repository.git.ssh.passphrase"), (String)"Git repository - passpharase").ifPresent(errors::add);
                        }
                    }
                }
            }
        }
        if ((url = configuration.get("repository.git.repositoryUrl")) != null && !ValidationUtils.containsBambooVariable((String)url)) {
            ValidationUtils.checkNotContainsRelaxedXssRelatedCharacters((String)url, (String)"Git repository - URL").ifPresent(errors::add);
            ValidationUtils.checkNotContainsShellInjectionRelatedCharacters((String)url, (String)"Git repository - URL").ifPresent(errors::add);
            ValidationUtils.checkUrl((String)url, SUPPORTED_SCHEMES, (String)"Git repository - URL").ifPresent(errors::add);
            if (authenticationType != null) {
                try {
                    URI repositoryUri = new URI(url);
                    String scheme = repositoryUri.getScheme();
                    if (((EnumSet)SUPPORTED_AUTH_TYPES.getOrDefault((Object)scheme, EnumSet.noneOf(GitAuthenticationType.class))).stream().noneMatch(Predicate.isEqual((Object)authenticationType))) {
                        errors.add(new ValidationProblem("Git repository - authentication  - not supported " + (Object)((Object)authenticationType) + " for protocol " + scheme));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (username != null && !ValidationUtils.containsBambooVariable((String)username)) {
            ValidationUtils.checkNotContainsRelaxedXssRelatedCharacters((String)username, (String)"Git repository - username").ifPresent(errors::add);
            ValidationUtils.checkNotContainsShellInjectionRelatedCharacters((String)username, (String)"Git repository - username").ifPresent(errors::add);
        }
        return errors;
    }

    @NotNull
    public Map<String, Object> exportBranchData(@NotNull VcsBranchDefinition vcsBranchDefinition) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        vcsBranchDefinition.getConfiguration().entrySet().forEach(e -> data.put(this.removePrefix((String)e.getKey()), e.getValue()));
        return data;
    }

    @NotNull
    public Map<String, String> importBranchData(@NotNull Map<String, Object> configurationMap) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        configurationMap.entrySet().forEach(e -> data.put(this.addPrefix((String)e.getKey()), e.getValue().toString()));
        return data;
    }

    @NotNull
    public List<ValidationProblem> validateBranchData(@NotNull Map<String, String> configuration) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (configuration.containsKey("repository.git.branch")) {
            ValidationUtils.checkNotContainsShellInjectionRelatedCharacters((String)configuration.get("repository.git.branch"), (String)"Git repository branch name").ifPresent(errors::add);
        }
        return errors;
    }

    @NotNull
    public Map<String, Object> exportChangeDetectionOptions(@NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> importChangeDetectionOptions(@NotNull Map<String, Object> configurationMap) {
        if (!configurationMap.isEmpty()) {
            throw new RuntimeException("Git repository importer doesn't accept extra configuration for change detection.");
        }
        return Collections.emptyMap();
    }

    @NotNull
    public List<ValidationProblem> validateChangeDetectionOptions(@NotNull Map<String, String> configuration) {
        if (!configuration.isEmpty()) {
            return Collections.singletonList(new ValidationProblem("Git repository importer doesn't accept extra configuration for change detection."));
        }
        return Collections.emptyList();
    }

    @NotNull
    public Map<String, Object> exportBranchDetectionOptions(@NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> importBranchDetectionOptions(@NotNull Map<String, Object> configurationMap) {
        if (!configurationMap.isEmpty()) {
            throw new RuntimeException("Git repository importer doesn't accept extra configuration for branch detection.");
        }
        return Collections.emptyMap();
    }

    @NotNull
    public List<ValidationProblem> validateBranchDetectionOptions(@NotNull Map<String, String> configuration) {
        if (!configuration.isEmpty()) {
            return Collections.singletonList(new ValidationProblem("Git repository importer doesn't accept extra configuration for branch detection."));
        }
        return Collections.emptyList();
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

