/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.errors.TransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGitExecutor {
    public static final String DEFAULT_BRANCH = "master";
    protected SshProxyService sshProxyService;
    private CapabilityContext capabilityContext;
    private CredentialsAccessor credentialsAccessor;
    protected CustomVariableContext customVariableContext;
    protected BuildDirectoryManager buildDirectoryManager;
    protected I18nResolver i18nResolver;
    protected TrustedKeyHelper trustedKeyHelper;
    private static final Logger log = Logger.getLogger(AbstractGitExecutor.class);

    public File getWorkingDirectory(@NotNull GitRepositoryAccessData accessData) {
        return this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent();
    }

    @Nullable
    public String getGitCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable");
    }

    @Nullable
    public String getSshCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable.ssh");
    }

    protected String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    public static boolean isUsingSharedCredentials(@NotNull Map<String, String> serverCfg) {
        String chosenAuthentication = serverCfg.getOrDefault("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        String sshCredentialsSource = serverCfg.getOrDefault("repository.git.sshCredentialsSource", GitSshCredentialsSource.CUSTOM.name());
        String passwordCredentialsSource = serverCfg.getOrDefault("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(chosenAuthentication) && GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(sshCredentialsSource) || GitAuthenticationType.PASSWORD.name().equals(chosenAuthentication) && GitPasswordCredentialsSource.SHARED_CREDENTIALS.name().equals(passwordCredentialsSource);
    }

    @NotNull
    public static String getSharedCredentialsIdField(@NotNull Map<String, String> config) {
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(config.getOrDefault("repository.git.authenticationType", GitAuthenticationType.NONE.name())) ? "repository.git.sharedCredentials" : "repository.git.passwordSharedCredentials";
    }

    protected GitRepositoryAccessData getAccessData(@NotNull VcsRepositoryData vcsRepositoryData) {
        String password;
        String username;
        String sshPassphrase;
        String sshKey;
        Long sharedCredentialsId;
        Map serverCfg = vcsRepositoryData.getVcsLocation().getConfiguration();
        String commandTimeoutString = (String)serverCfg.get("repository.git.commandTimeout");
        int commandTimeout = StringUtils.isNotBlank((CharSequence)commandTimeoutString) ? Integer.parseInt(commandTimeoutString) : 180;
        GitAuthenticationType gitAuthenticationType = GitAuthenticationType.valueOf((String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)serverCfg.get("repository.git.authenticationType")), (CharSequence)GitAuthenticationType.NONE.name()));
        if (AbstractGitExecutor.isUsingSharedCredentials(serverCfg)) {
            String sharedCredentialsIdString = (String)serverCfg.get(AbstractGitExecutor.getSharedCredentialsIdField(serverCfg));
            sharedCredentialsId = StringUtils.isNotBlank((CharSequence)sharedCredentialsIdString) ? Long.valueOf(Long.parseLong(sharedCredentialsIdString)) : null;
            Optional<CredentialsData> credentialsData = Optional.ofNullable(sharedCredentialsId).map(arg_0 -> ((CredentialsAccessor)this.credentialsAccessor).getCredentials(arg_0));
            if (credentialsData.isPresent()) {
                if (GitAuthenticationType.SSH_KEYPAIR.equals((Object)gitAuthenticationType)) {
                    SshCredentialsImpl sshCredentials = new SshCredentialsImpl(credentialsData.get());
                    sshKey = sshCredentials.getKey();
                    sshPassphrase = sshCredentials.getPassphrase();
                    username = "";
                    password = null;
                } else {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData.get());
                    username = passwordCredentials.getUsername();
                    password = passwordCredentials.getPassword();
                    sshKey = "";
                    sshPassphrase = "";
                }
            } else {
                sshKey = "";
                sshPassphrase = "";
                username = "";
                password = null;
            }
        } else {
            sshKey = serverCfg.getOrDefault("repository.git.ssh.key", "");
            sshPassphrase = serverCfg.getOrDefault("repository.git.ssh.passphrase", "");
            username = serverCfg.getOrDefault("repository.git.username", "");
            password = serverCfg.getOrDefault("repository.git.password", null);
            sharedCredentialsId = null;
        }
        return GitRepositoryAccessData.builder().repositoryUrl(StringUtils.trimToEmpty((String)((String)serverCfg.get("repository.git.repositoryUrl")))).username(username).password(password).branch(vcsRepositoryData.getBranch().getVcsBranch()).sshKey(sshKey).sshPassphrase(sshPassphrase).authenticationType(gitAuthenticationType).useShallowClones(Boolean.valueOf((String)serverCfg.get("repository.git.useShallowClones"))).useRemoteAgentCache(Boolean.valueOf((String)serverCfg.get("repository.git.useRemoteAgentCache"))).useSubmodules(Boolean.valueOf((String)serverCfg.get("repository.git.useSubmodules"))).commandTimeout(commandTimeout).verboseLogs(Boolean.valueOf((String)serverCfg.get("repository.git.verbose.logs"))).refSpecOverride(Boolean.valueOf((String)serverCfg.get("repository.git.fetch.whole.repository")) != false ? "refs/heads/*" : null).lfs(Boolean.valueOf(serverCfg.getOrDefault("repository.git.lfs", "false"))).sharedCredentialsId(sharedCredentialsId).build();
    }

    protected GitRepositoryAccessData.Builder getSubstitutedAccessDataBuilder(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData accessData = this.getAccessData(vcsRepositoryData);
        return GitRepositoryAccessData.builder(accessData).repositoryUrl(this.substituteString(accessData.getRepositoryUrl())).branch((VcsBranch)new VcsBranchImpl(this.substituteString(accessData.getVcsBranch().getName()))).username(this.substituteString(accessData.getUsername())).password(StringUtils.isNotBlank((CharSequence)accessData.getPassword()) ? accessData.getPassword() : "").sshKey(accessData.getSshKey()).sshPassphrase(accessData.getSshPassphrase());
    }

    protected GitRepositoryAccessData getSubstitutedAccessData(@NotNull VcsRepositoryData vcsRepositoryData) {
        return this.getSubstitutedAccessDataBuilder(vcsRepositoryData).build();
    }

    protected File getCacheDirectory(@NotNull GitRepositoryAccessData substitutedAccessData) {
        return GitCacheDirectory.getCacheDirectory(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), substitutedAccessData);
    }

    protected void rethrowOrRemoveDirectory(Exception originalException, BuildLogger buildLogger, File directory, String key) throws Exception {
        Throwable e = originalException;
        do {
            if (!(e instanceof TransportException)) continue;
            throw originalException;
        } while ((e = e.getCause()) != null);
        buildLogger.addBuildLogEntry(this.i18nResolver.getText(key, new Serializable[]{directory}));
        log.warn((Object)("Deleting directory " + directory));
        FileUtils.deleteQuietly((File)directory);
        Object[] filesInDirectory = directory.list();
        if (filesInDirectory != null) {
            log.error((Object)("Unable to delete files: " + Arrays.toString(filesInDirectory) + ", expect trouble"));
        }
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.trustedKeyHelper = trustedKeyHelper;
    }
}

