/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class HostNameNonSensitiveHostKeyRepository
implements HostKeyRepository {
    private static final Logger log = Logger.getLogger(HostNameNonSensitiveHostKeyRepository.class);
    private final Set<String> knownKeys = new HashSet<String>();
    private final HostKeyRepository delegate;

    HostNameNonSensitiveHostKeyRepository(@NotNull HostKeyRepository delegate) {
        this.delegate = delegate;
        for (HostKey hostKey : delegate.getHostKey()) {
            this.knownKeys.add(hostKey.getKey());
        }
    }

    public int check(String host, byte[] key) {
        try {
            HostKey hostKey = new HostKey(host, key);
            if (this.knownKeys.contains(hostKey.getKey())) {
                return 0;
            }
        }
        catch (JSchException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    public void add(HostKey hostkey, UserInfo ui) {
        this.delegate.add(hostkey, ui);
    }

    public void remove(String host, String type) {
        this.delegate.remove(host, type);
    }

    public void remove(String host, String type, byte[] key) {
        this.delegate.remove(host, type, key);
    }

    public String getKnownHostsRepositoryID() {
        return "known_hosts";
    }

    public HostKey[] getHostKey() {
        return this.delegate.getHostKey();
    }

    public HostKey[] getHostKey(String host, String type) {
        return this.delegate.getHostKey(host, type);
    }
}

