/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.exporter;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GitConfigurationExporter
implements VcsRepositoryDataExporter {
    private static Set<String> keysToSkip = ImmutableSet.of((Object)"repository.git.sharedCredentials", (Object)"repository.git.passwordSharedCredentials");
    private CredentialsAccessor credentialsAccessor;

    private Object getCredentialRef(@NotNull String key, @NotNull Map<String, String> configuration) {
        String credentialKey = configuration.get(key);
        CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(credentialKey));
        if (credentials != null) {
            return credentials.getOid().getValue();
        }
        return "unknownCredentials";
    }

    private String removePrefix(String key) {
        return key.substring("repository.git.".length());
    }

    private Object getObjectValue(String value) {
        try {
            if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
                return Boolean.valueOf(value);
            }
            if (StringUtils.isNumeric((CharSequence)value)) {
                return Long.parseLong(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @NotNull
    public Map<String, Object> locationDataToSerializableMap(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Map configuration = vcsLocationDefinition.getConfiguration();
        configuration.entrySet().stream().filter(e -> !keysToSkip.contains(e.getKey())).forEach(e -> data.put(this.removePrefix((String)e.getKey()), this.getObjectValue((String)e.getValue())));
        if (GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(configuration.get("repository.git.sshCredentialsSource"))) {
            data.put("sshSharedCredentials", this.getCredentialRef("repository.git.sharedCredentials", configuration));
        }
        if (GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(configuration.get("repository.git.passwordCredentialsSource"))) {
            data.put("passwordSharedCredentials", this.getCredentialRef("repository.git.passwordSharedCredentials", configuration));
        }
        return data;
    }

    @NotNull
    public Map<String, Object> branchDataToSerializableMap(@NotNull VcsBranchDefinition vcsBranchDefinition) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        vcsBranchDefinition.getConfiguration().entrySet().forEach(e -> data.put(this.removePrefix((String)e.getKey()), e.getValue()));
        return data;
    }

    @NotNull
    public Map<String, Object> changeDetectionOptionsToSerializableMap(@NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, Object> branchDetectionOptionsToSerializableMap(@NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return Collections.emptyMap();
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

