/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GitCacheDirectory {
    static final String GIT_REPOSITORY_CACHE_DIRECTORY = "_git-repositories-cache";
    static final Function<File, ManagedLock> cacheLockFactory = ManagedLocks.weakManagedLockFactory();
    private static final Logger log = Logger.getLogger(GitCacheDirectory.class);

    private GitCacheDirectory() {
    }

    @NotNull
    public static File getCacheDirectoryRoot(@NotNull File workingDirectory) {
        return new File(workingDirectory, GIT_REPOSITORY_CACHE_DIRECTORY);
    }

    @NotNull
    public static File getCacheDirectory(@NotNull File workingDirectory, @NotNull GitRepositoryAccessData repositoryData) {
        return new File(GitCacheDirectory.getCacheDirectoryRoot(workingDirectory), GitCacheDirectory.calculateRepositorySha(repositoryData));
    }

    @VisibleForTesting
    static String calculateRepositorySha(@NotNull GitRepositoryAccessData repositoryData) {
        return GitCacheDirectory.calculateAggregateSha(repositoryData.getRepositoryUrl(), repositoryData.getUsername());
    }

    static String calculateAggregateSha(String ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String param : params) {
            if (param != null) {
                try {
                    baos.write(param.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
                }
            }
            baos.write(0);
        }
        return DigestUtils.sha1Hex((byte[])baos.toByteArray());
    }

    public static ManagedLock getCacheLock(@NotNull File cache) {
        return cacheLockFactory.apply(cache);
    }
}

