/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVariableGenerator
extends AbstractGitExecutor
implements VcsVariableGenerator {
    private static final Logger log = Logger.getLogger(GitVariableGenerator.class);
    private static final String REPOSITORY_URL = "repositoryUrl";
    private static final String REPOSITORY_BRANCH = "branch";
    private static final String REPOSITORY_USERNAME = "username";

    @Nullable
    public String getLegacyPrefix() {
        return "repository.git";
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        HashMap variables = Maps.newHashMap();
        variables.put(REPOSITORY_URL, substitutedAccessData.getRepositoryUrl());
        variables.put(REPOSITORY_BRANCH, substitutedAccessData.getVcsBranch().getName());
        variables.put(REPOSITORY_USERNAME, substitutedAccessData.getUsername());
        return variables;
    }
}

