/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsChangeDetector;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangeDetector
extends AbstractGitExecutor
implements VcsChangeDetector {
    private static final Logger log = Logger.getLogger(GitChangeDetector.class);
    private BuildLoggerManager buildLoggerManager;

    @NotNull
    public BuildRepositoryChanges collectChangesSinceRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData lastRevisionData) throws RepositoryException {
        return this.collectChanges(planKey, repositoryData, lastRevisionData.getVcsRevisionKey(), null);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull String customRevision) throws RepositoryException {
        return this.collectChanges(planKey, repositoryData, customRevision, customRevision);
    }

    @NotNull
    private BuildRepositoryChanges collectChanges(@NotNull PlanKey planKey, @NotNull VcsRepositoryData vcsRepositoryData, @Nullable String lastVcsRevisionKey, final @Nullable String customRevision) throws RepositoryException {
        try {
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)planKey);
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
            final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
            HashAndSource latestRevision = helper.obtainLatestRevision();
            String fetchRevision = (String)MoreObjects.firstNonNull((Object)customRevision, (Object)latestRevision.getRef());
            String targetRevision = (String)MoreObjects.firstNonNull((Object)customRevision, (Object)latestRevision.getHash());
            final File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
            if (latestRevision.getHash().equals(lastVcsRevisionKey) && customRevision == null) {
                return new BuildRepositoryChangesImpl(latestRevision.getHash());
            }
            VcsBranchImpl actualBranch = null;
            if (customRevision != null) {
                try {
                    final String vcsBranchName = substitutedAccessData.getVcsBranch().getName();
                    String branchForSha = (String)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            helper.fetch(cacheDirectory, customRevision, false);
                            return helper.getBranchForSha(cacheDirectory, customRevision, vcsBranchName);
                        }
                    });
                    if (!StringUtils.equals((CharSequence)branchForSha, (CharSequence)vcsBranchName)) {
                        actualBranch = new VcsBranchImpl(branchForSha);
                        log.warn((Object)buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.adjustBranchForSha", new Serializable[]{vcsBranchName, customRevision, actualBranch.getName()})));
                    }
                }
                catch (Exception e) {
                    Throwables.propagateIfInstanceOf((Throwable)e, RepositoryException.class);
                    Throwables.propagate((Throwable)e);
                }
            }
            if (lastVcsRevisionKey == null) {
                return this.fetchAndCreateEmptyChangeset(vcsRepositoryData, buildLogger, helper, fetchRevision, targetRevision, cacheDirectory, (VcsBranch)actualBranch);
            }
            BuildRepositoryChanges buildChanges = this.fetchAndExtractChanges(lastVcsRevisionKey, buildLogger, helper, fetchRevision, targetRevision, cacheDirectory);
            if (buildChanges != null && !buildChanges.getChanges().isEmpty()) {
                buildChanges.setRepositoryId(vcsRepositoryData.getId());
                buildChanges.setActualBranch(actualBranch);
                return buildChanges;
            }
            return new BuildRepositoryChangesImpl(vcsRepositoryData.getId(), targetRevision, Collections.singletonList(CommitContextImpl.builder().changesetId(targetRevision).author("[unknown]").comment(this.i18nResolver.getText("repository.git.messages.unknownChanges", new Serializable[]{lastVcsRevisionKey, targetRevision})).date(new Date()).build()), vcsRepositoryData.getBranch().getVcsBranch());
        }
        catch (CancelException e) {
            throw e;
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private BuildRepositoryChanges fetchAndExtractChanges(@Nullable String lastVcsRevisionKey, BuildLogger buildLogger, GitOperationHelper helper, String fetchRevision, String targetRevision, File cacheDirectory) {
        return (BuildRepositoryChanges)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
            try {
                helper.fetch(cacheDirectory, fetchRevision, false);
                return helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                try {
                    this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.ccRecover.failedToCollectChangesets");
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                    helper.fetch(cacheDirectory, fetchRevision, false);
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", new Serializable[]{cacheDirectory}));
                    BuildRepositoryChanges extractedChanges = helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.completed"));
                    return extractedChanges;
                }
                catch (CancelException e2) {
                    throw e2;
                }
                catch (Exception e2) {
                    log.error((Object)buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                    return null;
                }
            }
        });
    }

    @NotNull
    private BuildRepositoryChanges fetchAndCreateEmptyChangeset(@NotNull VcsRepositoryData vcsRepositoryData, BuildLogger buildLogger, GitOperationHelper helper, String fetchRevision, String targetRevision, File cacheDirectory, VcsBranch actualBranch) throws RepositoryException {
        buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRepositoryNeverChecked", new Serializable[]{fetchRevision}));
        try {
            GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
                try {
                    helper.fetch(cacheDirectory, fetchRevision, false);
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                    helper.fetch(cacheDirectory, fetchRevision, false);
                }
                return null;
            });
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        BuildRepositoryChangesImpl buildRepositoryChanges = new BuildRepositoryChangesImpl(vcsRepositoryData.getId(), targetRevision, null);
        buildRepositoryChanges.setActualBranch(actualBranch);
        return buildRepositoryChanges;
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        GitRepositoryAccessData accessData = this.getSubstitutedAccessData(vcsRepositoryData);
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{accessData.getRepositoryUrl(), accessData.getVcsBranch().getName(), accessData.getUsername(), accessData.getSshKey()});
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

