/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SharedCredentialDepender;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.BranchIntegrationHelper;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitCacheHandler;
import com.atlassian.bamboo.plugins.git.GitMavenPomAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.GitRepositoryFacade;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.plugins.git.helper.GitRepositorySharedCredentialsHelper;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CacheDescription;
import com.atlassian.bamboo.repository.CacheHandler;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CheckoutCustomRevisionDataAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.ScmTypePublishingRepository;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.repository.UniqueRevisionIdRepository;
import com.atlassian.bamboo.repository.ui.EditActionAwareRepository;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.RequirementsAwareRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.opensymphony.xwork.ValidationAware;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepository
extends AbstractStandaloneRepository
implements AdvancedConfigurationAwareRepository,
BranchInformationProvider,
BranchMergingAwareRepository,
CacheHandler,
CachingAwareRepository,
CheckoutCustomRevisionDataAwareRepository,
CustomSourceDirectoryAwareRepository,
CustomVariableProviderRepository,
DeploymentAwareRepository,
GitRepositoryFacade,
MavenPomAccessorCapableRepository,
PushCapableRepository,
RequirementsAwareRepository,
SelectableAuthenticationRepository,
SharedCredentialDepender,
UniqueRevisionIdRepository,
TestConnectionAwareRepository,
ScmTypePublishingRepository,
EditActionAwareRepository {
    public static final String DEFAULT_BRANCH = "master";
    private static final String REPOSITORY_GIT_NAME = "repository.git.name";
    private static final String REPOSITORY_URL = "repositoryUrl";
    public static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
    public static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
    public static final String REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE = "repository.git.sshCredentialsSource";
    public static final String REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE = "repository.git.passwordCredentialsSource";
    private static final String REPOSITORY_USERNAME = "username";
    public static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
    public static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    private static final String REPOSITORY_BRANCH = "branch";
    public static final String REPOSITORY_GIT_BRANCH = "repository.git.branch";
    public static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
    public static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
    public static final String REPOSITORY_GIT_USE_SHALLOW_CLONES = "repository.git.useShallowClones";
    public static final String REPOSITORY_GIT_USE_REMOTE_AGENT_CACHE = "repository.git.useRemoteAgentCache";
    public static final String REPOSITORY_GIT_USE_SUBMODULES = "repository.git.useSubmodules";
    public static final String REPOSITORY_GIT_MAVEN_PATH = "repository.git.maven.path";
    public static final String REPOSITORY_GIT_COMMAND_TIMEOUT = "repository.git.commandTimeout";
    public static final String REPOSITORY_GIT_VERBOSE_LOGS = "repository.git.verbose.logs";
    public static final String REPOSITORY_GIT_FETCH_WHOLE_REPOSITORY = "repository.git.fetch.whole.repository";
    public static final String REPOSITORY_GIT_SSH_SHAREDCREDENTIALS_ID = "repository.git.sharedCredentials";
    public static final String REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID = "repository.git.passwordSharedCredentials";
    public static final String REPOSITORY_GIT_SHAREDCREDENTIALS_DELETED = "repository.git.sharedCredentials.deleted";
    @VisibleForTesting
    static final String TEMPORARY_GIT_PASSWORD = "temporary.git.password";
    @VisibleForTesting
    static final String TEMPORARY_GIT_PASSWORD_CHANGE = "temporary.git.password.change";
    @VisibleForTesting
    static final String TEMPORARY_GIT_SSH_PASSPHRASE = "temporary.git.ssh.passphrase";
    @VisibleForTesting
    static final String TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE = "temporary.git.ssh.passphrase.change";
    @VisibleForTesting
    static final String TEMPORARY_GIT_SSH_KEY_FROM_FILE = "temporary.git.ssh.keyfile";
    @VisibleForTesting
    static final String TEMPORARY_GIT_SSH_KEY_CHANGE = "temporary.git.ssh.key.change";
    protected static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    static final int DEFAULT_COMMAND_TIMEOUT_IN_MINUTES = 180;
    private static final Logger log = Logger.getLogger(GitRepository.class);
    private BranchIntegrationHelper branchIntegrationHelper;
    private GitRepositoryAccessData accessData = new GitRepositoryAccessData();
    private transient String pathToPom;
    private boolean sharedCredentialsDeleted;
    private transient CapabilityContext capabilityContext;
    private transient I18nResolver i18nResolver;
    private transient TrustedKeyHelper trustedKeyHelper;
    private transient GitCacheHandler gitCacheHandler;
    private transient SshProxyService sshProxyService;
    private transient EncryptionService encryptionService;
    private transient CredentialsAccessor credentialsAccessor;

    @NotNull
    public String getName() {
        return this.i18nResolver.getText(REPOSITORY_GIT_NAME);
    }

    @NotNull
    public String getScm() {
        return "git";
    }

    public String getHost() {
        return "";
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitRepository) {
            GitRepository gitRepo = (GitRepository)repository;
            return !new EqualsBuilder().append((Object)this.accessData.getRepositoryUrl(), (Object)gitRepo.accessData.getRepositoryUrl()).append((Object)this.accessData.getVcsBranch(), (Object)gitRepo.accessData.getVcsBranch()).append((Object)this.accessData.getUsername(), (Object)gitRepo.accessData.getUsername()).append((Object)this.accessData.getSshKey(), (Object)gitRepo.accessData.getSshKey()).isEquals();
        }
        return true;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey.getKey(), targetRevision, targetRevision);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey, lastVcsRevisionKey, null);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey, @Nullable String customRevision) throws RepositoryException {
        try {
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)PlanKeys.getPlanKey((String)planKey));
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
            GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
            String latestRevision = helper.obtainLatestRevision();
            String fetchRevision = (String)MoreObjects.firstNonNull((Object)customRevision, (Object)substitutedAccessData.getVcsBranch().getName());
            String targetRevision = (String)MoreObjects.firstNonNull((Object)customRevision, (Object)latestRevision);
            File cacheDirectory = this.getCacheDirectory();
            if (latestRevision.equals(lastVcsRevisionKey) && customRevision == null) {
                return new BuildRepositoryChangesImpl(latestRevision);
            }
            VcsBranchImpl overriddenBranch = null;
            if (customRevision != null) {
                helper.fetch(cacheDirectory, customRevision, false);
                String vcsBranchName = substitutedAccessData.getVcsBranch().getName();
                String branchForSha = helper.getBranchForSha(cacheDirectory, customRevision, vcsBranchName);
                if (!StringUtils.equals((CharSequence)branchForSha, (CharSequence)vcsBranchName)) {
                    overriddenBranch = new VcsBranchImpl(branchForSha);
                    log.warn((Object)buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.adjustBranchForSha", new Serializable[]{vcsBranchName, customRevision, overriddenBranch.getName()})));
                }
            }
            if (lastVcsRevisionKey == null) {
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRepositoryNeverChecked", new Serializable[]{fetchRevision}));
                this.fetch(helper, buildLogger, cacheDirectory, fetchRevision);
                BuildRepositoryChangesImpl buildRepositoryChanges = new BuildRepositoryChangesImpl(targetRevision);
                if (overriddenBranch != null) {
                    buildRepositoryChanges.setOverriddenVcsBranch((VcsBranch)overriddenBranch);
                }
                return buildRepositoryChanges;
            }
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> this.fetchAndExtractCommits(helper, buildLogger, cacheDirectory, lastVcsRevisionKey, fetchRevision, targetRevision));
            if (buildChanges != null && !buildChanges.getChanges().isEmpty()) {
                if (overriddenBranch != null) {
                    buildChanges.setOverriddenVcsBranch((VcsBranch)overriddenBranch);
                }
                return buildChanges;
            }
            CommitContextImpl commit = CommitContextImpl.builder().changesetId(targetRevision).author("[unknown]").comment(this.i18nResolver.getText("repository.git.messages.unknownChanges", new Serializable[]{lastVcsRevisionKey, targetRevision})).date(new Date()).build();
            return new BuildRepositoryChangesImpl(targetRevision, Collections.singletonList(commit));
        }
        catch (CancelException e) {
            throw e;
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private void fetch(final GitOperationHelper helper, final BuildLogger buildLogger, final File cacheDirectory, final String fetchRevision) throws RepositoryException {
        try {
            GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        helper.fetch(cacheDirectory, fetchRevision, false);
                    }
                    catch (CancelException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                        buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                        helper.fetch(cacheDirectory, fetchRevision, false);
                    }
                    return null;
                }
            });
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private BuildRepositoryChanges fetchAndExtractCommits(GitOperationHelper helper, BuildLogger buildLogger, File cacheDirectory, String lastVcsRevisionKey, String fetchRevision, String targetRevision) {
        try {
            helper.fetch(cacheDirectory, fetchRevision, false);
            return helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.ccRecover.failedToCollectChangesets");
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                helper.fetch(cacheDirectory, fetchRevision, false);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", new Serializable[]{cacheDirectory}));
                BuildRepositoryChanges extractedChanges = helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.completed"));
                return extractedChanges;
            }
            catch (CancelException e2) {
                throw e2;
            }
            catch (Exception e2) {
                log.error((Object)buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                return null;
            }
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        return this.retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory, 1);
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory, int depth) throws RepositoryException {
        PlanVcsRevisionData planVcsRevisionData = new PlanVcsRevisionData(vcsRevisionKey, null);
        return this.retrieveSourceCode(buildContext, planVcsRevisionData, sourceDirectory, depth);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable PlanVcsRevisionData planVcsRevisionData, @NotNull File sourceDirectory, int depth) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    protected boolean isOnLocalAgent() {
        return AgentTypeHolder.get() == AgentType.LOCAL;
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        return helper.getOpenBranches(substitutedAccessData, this.getWorkingDirectory());
    }

    public void pushRevision(@NotNull File sourceDirectory, @Nullable String vcsRevisionKey) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        helper.pushRevision(sourceDirectory, vcsRevisionKey);
    }

    @NotNull
    public String commit(@NotNull File sourceDirectory, @NotNull String message) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        return helper.commit(sourceDirectory, message, this.branchIntegrationHelper.getCommitterName((Repository)this), this.branchIntegrationHelper.getCommitterEmail((Repository)this));
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
                return new CacheId((Repository)this, new String[]{substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUsername(), substitutedAccessData.getSshKey()});
            }
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.accessData.getVcsBranch();
    }

    public void setVcsBranch(@NotNull VcsBranch branch) {
        this.accessData = GitRepositoryAccessData.builder(this.accessData).branch(branch).build();
    }

    public boolean mergeWorkspaceWith(@NotNull BuildContext buildContext, @NotNull File workspaceDir, final @NotNull String targetRevision) throws RepositoryException {
        GitOperationHelper connector;
        block7: {
            final BuildLogger buildLogger = this.buildLoggerManager.getLogger(buildContext.getEntityKey());
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder().useShallowClones(false).build();
            connector = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
            final File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
            try {
                if (this.isOnLocalAgent() || this.getAccessData().isUseRemoteAgentCache()) {
                    GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                connector.fetch(cacheDirectory, targetRevision, false);
                                connector.checkRevisionExistsInCacheRepository(cacheDirectory, targetRevision);
                            }
                            catch (CancelException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                                buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                                connector.fetch(cacheDirectory, targetRevision, false);
                                buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", new Serializable[]{cacheDirectory}));
                            }
                            return null;
                        }
                    });
                    break block7;
                }
                try {
                    connector.fetch(workspaceDir, targetRevision, false);
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.rethrowOrRemoveDirectory(e, buildLogger, workspaceDir, "repository.git.messages.rsRecover.failedToFetchWorkingDir");
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{workspaceDir}));
                    connector.fetch(workspaceDir, targetRevision, false);
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
            }
        }
        return connector.merge(workspaceDir, targetRevision, this.branchIntegrationHelper.getCommitterName((Repository)this), this.branchIntegrationHelper.getCommitterEmail((Repository)this));
    }

    public boolean isMergingSupported() {
        return GitOperationHelperFactory.isNativeGitEnabled(this);
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        return null;
    }

    public CommitContext getLastCommit() throws RepositoryException {
        NullBuildLogger buildLogger = new NullBuildLogger();
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
        final String targetRevision = helper.obtainLatestRevision();
        final File cacheDirectory = this.getCacheDirectory();
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Supplier)new Supplier<Result<RepositoryException, CommitContext>>(){

            @Override
            public Result<RepositoryException, CommitContext> get() {
                try {
                    CommitContext commit = helper.getCommit(cacheDirectory, targetRevision);
                    log.info((Object)("Found " + commit.getChangeSetId() + " as the last commit for " + this));
                    return Result.result((Object)commit);
                }
                catch (RepositoryException e) {
                    try {
                        log.debug((Object)"Fetching remote repository");
                        helper.fetch(cacheDirectory, targetRevision, false);
                        return Result.result((Object)helper.getCommit(cacheDirectory, targetRevision));
                    }
                    catch (RepositoryException e2) {
                        return Result.exception((Throwable)e2);
                    }
                }
            }
        });
        return (CommitContext)result.getResultThrowException();
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)180);
        buildConfiguration.clearTree(REPOSITORY_GIT_VERBOSE_LOGS);
        buildConfiguration.clearTree(REPOSITORY_GIT_FETCH_WHOLE_REPOSITORY);
        buildConfiguration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)true);
        buildConfiguration.setProperty(REPOSITORY_GIT_USE_REMOTE_AGENT_CACHE, (Object)false);
        buildConfiguration.clearTree(REPOSITORY_GIT_USE_SUBMODULES);
        buildConfiguration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, (Object)GitAuthenticationType.NONE.name());
        buildConfiguration.setProperty(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, (Object)this.getDefaultSshCredentialsSource().name());
        buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE, (Object)this.getDefaultPasswordCredentialsSource().name());
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)buildConfiguration.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180));
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.encryptionService.encrypt(buildConfiguration.getString(TEMPORARY_GIT_PASSWORD)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.encryptionService.encrypt(buildConfiguration.getString(TEMPORARY_GIT_SSH_PASSPHRASE)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(TEMPORARY_GIT_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                String key;
                try {
                    key = FileUtils.readFileToString((File)((File)o));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
                buildConfiguration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.encryptionService.encrypt(key));
            } else {
                buildConfiguration.clearProperty(REPOSITORY_GIT_SSH_KEY);
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        String sshPassphrase = "";
        String sshKey = "";
        String username = "";
        String password = null;
        Long sharedCredentialsId = null;
        String chosenAuthentication = config.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE, GitAuthenticationType.NONE.name());
        if (GitRepositorySharedCredentialsHelper.isUsingSharedCredentials(config)) {
            sharedCredentialsId = config.getLong(GitRepositorySharedCredentialsHelper.getSharedCredentialsIdField(config), null);
            Optional<CredentialsData> credentialsData = Optional.ofNullable(sharedCredentialsId).map(arg_0 -> ((CredentialsAccessor)this.credentialsAccessor).getCredentials(arg_0));
            if (credentialsData.isPresent()) {
                if (GitAuthenticationType.SSH_KEYPAIR.name().equals(chosenAuthentication)) {
                    SshCredentialsImpl sshCredentials = new SshCredentialsImpl(credentialsData.get());
                    sshKey = sshCredentials.getKey();
                    sshPassphrase = sshCredentials.getPassphrase();
                } else {
                    UsernamePasswordCredentials passwordCredentials = new UsernamePasswordCredentials(credentialsData.get());
                    username = passwordCredentials.getUsername();
                    password = passwordCredentials.getPassword();
                }
            } else {
                this.sharedCredentialsDeleted = true;
            }
        } else {
            sshPassphrase = config.getString(REPOSITORY_GIT_SSH_PASSPHRASE, "");
            sshKey = config.getString(REPOSITORY_GIT_SSH_KEY, "");
            username = config.getString(REPOSITORY_GIT_USERNAME, "");
            password = config.getString(REPOSITORY_GIT_PASSWORD, null);
        }
        VcsBranchImpl branch = new VcsBranchImpl((String)StringUtils.defaultIfEmpty((CharSequence)config.getString(REPOSITORY_GIT_BRANCH, ""), (CharSequence)DEFAULT_BRANCH));
        this.accessData = GitRepositoryAccessData.builder().repositoryUrl(StringUtils.trimToEmpty((String)config.getString(REPOSITORY_GIT_REPOSITORY_URL))).username(username).password(password).branch((VcsBranch)branch).sshKey(sshKey).sshPassphrase(sshPassphrase).authenticationType(GitAuthenticationType.valueOf(chosenAuthentication)).useShallowClones(config.getBoolean(REPOSITORY_GIT_USE_SHALLOW_CLONES)).useRemoteAgentCache(config.getBoolean(REPOSITORY_GIT_USE_REMOTE_AGENT_CACHE, false)).useSubmodules(config.getBoolean(REPOSITORY_GIT_USE_SUBMODULES, false)).commandTimeout(config.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180)).verboseLogs(config.getBoolean(REPOSITORY_GIT_VERBOSE_LOGS, false)).refSpecOverride(config.getBoolean(REPOSITORY_GIT_FETCH_WHOLE_REPOSITORY, false) ? "refs/heads/" + "*" : null).sharedCredentialsId(sharedCredentialsId).build();
        this.pathToPom = config.getString(REPOSITORY_GIT_MAVEN_PATH);
    }

    @NotNull
    public Iterable<Long> getSharedCredentialIds() {
        return Optional.ofNullable(this.accessData.getSharedCredentialsId()).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public void beforeEditPageRendering(@NotNull HierarchicalConfiguration configuration) {
        configuration.setProperty(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, (Object)configuration.getString(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, this.getDefaultSshCredentialsSource().name()));
        configuration.setProperty(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE, (Object)configuration.getString(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE, this.getDefaultPasswordCredentialsSource().name()));
    }

    public ErrorCollection beforeSave(@NotNull HierarchicalConfiguration configuration) {
        return new SimpleErrorCollection();
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GIT_REPOSITORY_URL, (Object)this.accessData.getRepositoryUrl());
        configuration.setProperty(REPOSITORY_GIT_BRANCH, (Object)this.accessData.getVcsBranch().getName());
        configuration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)this.accessData.isUseShallowClones());
        configuration.setProperty(REPOSITORY_GIT_USE_REMOTE_AGENT_CACHE, (Object)this.accessData.isUseRemoteAgentCache());
        configuration.setProperty(REPOSITORY_GIT_USE_SUBMODULES, (Object)this.accessData.isUseSubmodules());
        configuration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)this.accessData.getCommandTimeout());
        configuration.setProperty(REPOSITORY_GIT_VERBOSE_LOGS, (Object)this.accessData.isVerboseLogs());
        configuration.setProperty(REPOSITORY_GIT_FETCH_WHOLE_REPOSITORY, (Object)(this.accessData.getRefSpecOverride() != null ? 1 : 0));
        configuration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, (Object)this.accessData.getAuthenticationType().name());
        Long sharedCredentialsId = this.accessData.getSharedCredentialsId();
        if (sharedCredentialsId != null) {
            if (this.sharedCredentialsDeleted) {
                configuration.setProperty(REPOSITORY_GIT_SHAREDCREDENTIALS_DELETED, (Object)true);
            }
            if (this.accessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR) {
                configuration.setProperty(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, (Object)GitSshCredentialsSource.SHARED_CREDENTIALS.name());
                configuration.setProperty(REPOSITORY_GIT_SSH_SHAREDCREDENTIALS_ID, (Object)sharedCredentialsId);
            } else {
                configuration.setProperty(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE, (Object)GitPasswordCredentialsSource.SHARED_CREDENTIALS.name());
                configuration.setProperty(REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID, (Object)sharedCredentialsId);
            }
        } else {
            if (this.accessData.getAuthenticationType() == GitAuthenticationType.SSH_KEYPAIR) {
                configuration.setProperty(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, (Object)GitSshCredentialsSource.CUSTOM.name());
            } else if (this.accessData.getAuthenticationType() == GitAuthenticationType.PASSWORD) {
                configuration.setProperty(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE, (Object)GitPasswordCredentialsSource.CUSTOM.name());
            }
            configuration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.accessData.getSshKey());
            configuration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.accessData.getSshPassphrase());
            configuration.setProperty(REPOSITORY_GIT_USERNAME, (Object)this.accessData.getUsername());
            configuration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.accessData.getPassword());
        }
        return configuration;
    }

    @NotNull
    public ErrorCollection validateForConnectionTesting(@NotNull BuildConfiguration configuration) {
        boolean changingSshKey;
        boolean usingSshAuth = GitAuthenticationType.SSH_KEYPAIR.name().equals(configuration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE, ""));
        boolean usingCustomSshKey = usingSshAuth && GitSshCredentialsSource.CUSTOM.name().equals(configuration.getString(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE, ""));
        boolean bl = changingSshKey = usingCustomSshKey && configuration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE, false);
        if (changingSshKey) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addError(TEMPORARY_GIT_SSH_KEY_FROM_FILE, this.i18nResolver.getText("repository.test.connection.private.key.not.received"));
            return errorCollection;
        }
        return this.validate(configuration);
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String key;
        ErrorCollection errorCollection;
        block20: {
            errorCollection = super.validate(buildConfiguration);
            String repositoryUrl = StringUtils.trim((String)buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL));
            GitAuthenticationType authenticationType = GitAuthenticationType.valueOf(buildConfiguration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)REPOSITORY_GIT_REPOSITORY_URL, (String)this.substituteString(buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL)))) {
                return errorCollection;
            }
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)REPOSITORY_GIT_BRANCH, (String)this.substituteString(buildConfiguration.getString(REPOSITORY_GIT_BRANCH)))) {
                return errorCollection;
            }
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)REPOSITORY_GIT_USERNAME, (String)this.substituteString(buildConfiguration.getString(REPOSITORY_GIT_USERNAME)))) {
                return errorCollection;
            }
            if (StringUtils.isBlank((CharSequence)repositoryUrl)) {
                errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, this.i18nResolver.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                GitPasswordCredentialsSource passwordCredentialsSource = authenticationType == GitAuthenticationType.PASSWORD ? GitPasswordCredentialsSource.valueOf(buildConfiguration.getString(REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE)) : null;
                boolean hasUsername = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)buildConfiguration.getString(REPOSITORY_GIT_USERNAME));
                boolean hasPassword = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)buildConfiguration.getString(REPOSITORY_GIT_PASSWORD));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
                        GitSshCredentialsSource sshCredentialsSource;
                        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                            errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.i18nResolver.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                        }
                        if ((sshCredentialsSource = GitSshCredentialsSource.valueOf(buildConfiguration.getString(REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE))) == GitSshCredentialsSource.SHARED_CREDENTIALS && buildConfiguration.getLong(REPOSITORY_GIT_SSH_SHAREDCREDENTIALS_ID, null) == null) {
                            errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        }
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        if (passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS && buildConfiguration.getLong(REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID, null) == null) {
                            errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        } else {
                            String errorField;
                            boolean duplicatePassword;
                            boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((CharSequence)uri.getUser());
                            boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((CharSequence)uri.getPass());
                            if (duplicateUsername || duplicatePassword) {
                                errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, (duplicateUsername ? this.i18nResolver.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.i18nResolver.getText("repository.git.messages.duplicatePasswordField") : ""));
                            }
                            if (duplicateUsername) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID : REPOSITORY_GIT_USERNAME;
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicateUsernameField"));
                            }
                            if (duplicatePassword) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID : TEMPORARY_GIT_PASSWORD_CHANGE;
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicatePasswordField"));
                            }
                            if (uri.getHost() == null && hasUsername) {
                                errorCollection.addError(REPOSITORY_GIT_USERNAME, this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block20;
                    String fieldForError = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID : REPOSITORY_GIT_USERNAME;
                    errorCollection.addError(fieldForError, this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        if (buildConfiguration.getString(REPOSITORY_GIT_MAVEN_PATH, "").contains("..")) {
            errorCollection.addError(REPOSITORY_GIT_MAVEN_PATH, this.i18nResolver.getText("repository.git.messages.invalidPomPath"));
        }
        if (!"".equals(key = buildConfiguration.getString(REPOSITORY_GIT_SSH_KEY, "")) && !this.encryptionService.decrypt(key).contains("-----BEGIN")) {
            errorCollection.addError(TEMPORARY_GIT_SSH_KEY_CHANGE, this.i18nResolver.getText("repository.git.messages.invalidSshKeys"));
        }
        return errorCollection;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(REPOSITORY_GIT_REPOSITORY_URL, substitutedAccessData.getRepositoryUrl());
        variables.put(REPOSITORY_GIT_BRANCH, substitutedAccessData.getVcsBranch().getName());
        variables.put(REPOSITORY_GIT_USERNAME, substitutedAccessData.getUsername());
        return variables;
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(REPOSITORY_URL, substitutedAccessData.getRepositoryUrl());
        variables.put(REPOSITORY_BRANCH, substitutedAccessData.getVcsBranch().getName());
        variables.put(REPOSITORY_USERNAME, substitutedAccessData.getUsername());
        return variables;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new GitMavenPomAccessor(this, this.sshProxyService, this.i18nResolver, this.getGitCapability(), this.trustedKeyHelper).withPath(this.pathToPom);
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Arrays.stream(GitAuthenticationType.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthTypeName((String)name))).collect(Collectors.toList());
    }

    @NotNull
    public List<NameValuePair> getSshCredentialsSources() {
        return Arrays.stream(GitSshCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getSshCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    @NotNull
    public List<NameValuePair> getPasswordCredentialsSources() {
        return Arrays.stream(GitPasswordCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getPasswordCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    @NotNull
    public List<NameValuePair> getSshSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials");
    }

    @NotNull
    public List<NameValuePair> getPasswordSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials");
    }

    @NotNull
    private List<NameValuePair> getSharedCredentials(String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials(pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName())).collect(Collectors.toList());
    }

    public String getAuthType() {
        return this.accessData.getAuthenticationType().name();
    }

    @NotNull
    public ErrorCollection testConnection(long timeout, @NotNull TimeUnit unit) {
        return (ErrorCollection)CacheAwareness.withValuesOlderThanTimestampReloaded(this::testConnectionToRepository, (long)System.currentTimeMillis(), (CacheAwareness.CacheInfo[])new CacheAwareness.CacheInfo[]{CacheAwareness.ANY});
    }

    @NotNull
    private ErrorCollection testConnectionToRepository() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            NullBuildLogger buildLogger = new NullBuildLogger();
            GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
            GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver, this.trustedKeyHelper);
            helper.obtainLatestRevision();
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                if (cause instanceof HostKeyVerificationException) {
                    this.handleHostKeyVerificationException((ErrorCollection)errorCollection, (HostKeyVerificationException)cause);
                } else {
                    this.handleTestConnectionException((ErrorCollection)errorCollection, (RepositoryException)cause);
                }
            }
            throw e;
        }
        catch (HostKeyVerificationException e) {
            this.handleHostKeyVerificationException((ErrorCollection)errorCollection, e);
        }
        catch (RepositoryException e) {
            this.handleTestConnectionException((ErrorCollection)errorCollection, e);
        }
        return errorCollection;
    }

    private void handleTestConnectionException(@NotNull ErrorCollection errorCollection, @NotNull RepositoryException repositoryException) {
        errorCollection.addErrorMessage(BambooStringUtils.firstNotBlank((String[])new String[]{repositoryException.getStdout(), repositoryException.getStderr(), repositoryException.getMessage(), this.i18nResolver.getText("repository.test.connection.error.unknown")}));
    }

    private void handleHostKeyVerificationException(@NotNull ErrorCollection errorCollection, @NotNull HostKeyVerificationException exception) {
        TrustedKey trustedKey = exception.getTrustedKey();
        String errorMessage = trustedKey == null || StringUtils.isBlank((CharSequence)trustedKey.getKey()) ? this.i18nResolver.getText("repository.test.connection.error.host.key.unknown") : this.i18nResolver.getText("repository.test.connection.error.host.key", new Serializable[]{trustedKey.getHost(), trustedKey.getKey()});
        errorCollection.addError(HOST_KEY, errorMessage);
    }

    private String getAuthTypeName(String authType) {
        return this.i18nResolver.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    private String getSshCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.sshCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private String getPasswordCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.passwordCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private GitSshCredentialsSource getDefaultSshCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials") ? GitSshCredentialsSource.SHARED_CREDENTIALS : GitSshCredentialsSource.CUSTOM;
    }

    private GitPasswordCredentialsSource getDefaultPasswordCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials") ? GitPasswordCredentialsSource.SHARED_CREDENTIALS : GitPasswordCredentialsSource.CUSTOM;
    }

    GitRepositoryAccessData.Builder getSubstitutedAccessDataBuilder() {
        String decryptSshKey;
        try {
            decryptSshKey = this.encryptionService.decrypt(this.accessData.getSshKey());
        }
        catch (EncryptionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            decryptSshKey = "";
        }
        return GitRepositoryAccessData.builder(this.accessData).repositoryUrl(this.substituteString(this.accessData.getRepositoryUrl())).branch((VcsBranch)new VcsBranchImpl(this.substituteString(this.accessData.getVcsBranch().getName()))).username(this.substituteString(this.accessData.getUsername())).password(StringUtils.isNotBlank((CharSequence)this.accessData.getPassword()) ? this.encryptionService.decrypt(this.accessData.getPassword()) : "").sshKey(decryptSshKey).sshPassphrase(this.encryptionService.decrypt(this.accessData.getSshPassphrase()));
    }

    GitRepositoryAccessData getSubstitutedAccessData() {
        return this.getSubstitutedAccessDataBuilder().build();
    }

    private void rethrowOrRemoveDirectory(Exception originalException, BuildLogger buildLogger, File directory, String key) throws Exception {
        Throwable e = originalException;
        do {
            if (!(e instanceof TransportException)) continue;
            throw originalException;
        } while ((e = e.getCause()) != null);
        buildLogger.addBuildLogEntry(this.i18nResolver.getText(key, new Serializable[]{directory}));
        log.warn((Object)("Deleting directory " + directory));
        BambooPathUtils.deleteQuietly((Path)directory.toPath());
        Object[] filesInDirectory = directory.list();
        if (filesInDirectory != null) {
            log.error((Object)("Unable to delete files: " + Arrays.toString(filesInDirectory) + ", expect trouble"));
        }
    }

    public boolean isUseShallowClones() {
        return this.accessData.isUseShallowClones();
    }

    public boolean isUseSubmodules() {
        return this.accessData.isUseSubmodules();
    }

    public String getRepositoryUrl() {
        return this.accessData.getRepositoryUrl();
    }

    @NotNull
    public String getLocationIdentifier() {
        return this.accessData.getRepositoryUrl();
    }

    public int getCommandTimeout() {
        return this.accessData.getCommandTimeout();
    }

    public boolean getVerboseLogs() {
        return this.accessData.isVerboseLogs();
    }

    public String getAuthTypeName() {
        return this.getAuthTypeName(this.getAuthType());
    }

    public File getCacheDirectory() {
        return this.getCacheDirectory(this.getSubstitutedAccessData());
    }

    public File getCacheDirectory(GitRepositoryAccessData accessData) {
        return GitCacheDirectory.getCacheDirectory(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), accessData);
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.trustedKeyHelper = trustedKeyHelper;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public String getOptionDescription() {
        String capabilitiesLink = ServletActionContext.getRequest().getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        return this.i18nResolver.getText("repository.git.description", new Serializable[]{this.getGitCapability(), capabilitiesLink});
    }

    @NotNull
    public Set<Requirement> getRequirements() {
        return new HashSet<Requirement>();
    }

    @Nullable
    public String getGitCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable");
    }

    @Nullable
    public String getSshCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable.ssh");
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    public void setBranchIntegrationHelper(BranchIntegrationHelper branchIntegrationHelper) {
        this.branchIntegrationHelper = branchIntegrationHelper;
    }

    public GitRepositoryAccessData getAccessData() {
        return this.accessData;
    }

    public void setGitCacheHandler(GitCacheHandler gitCacheHandler) {
        this.gitCacheHandler = gitCacheHandler;
    }

    public void setAccessData(GitRepositoryAccessData accessData) {
        this.accessData = accessData;
    }

    @NotNull
    public String getHandlerDescription() {
        return this.i18nResolver.getText("manageCaches.git.description");
    }

    @NotNull
    public Collection<CacheDescription> getCacheDescriptions() {
        return this.gitCacheHandler.getCacheDescriptions();
    }

    public void deleteCaches(@NotNull Collection<String> strings, @NotNull ValidationAware validationAware) {
        this.gitCacheHandler.deleteCaches(strings, validationAware);
    }

    public void deleteUnusedCaches(@NotNull ValidationAware validationAware) {
        this.gitCacheHandler.deleteUnusedCaches(validationAware);
    }

    public boolean isSharedCredentialsDeleted() {
        return this.sharedCredentialsDeleted;
    }

    public boolean usePollingForBranchDetection() {
        return true;
    }

    @Override
    @Nullable
    public GitRepository getGitRepository() {
        return this;
    }
}

