/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.JGitOperationHelper;
import com.atlassian.bamboo.plugins.git.NativeGitOperationHelper;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.sal.api.message.I18nResolver;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GitOperationHelperFactory {
    private GitOperationHelperFactory() {
    }

    public static GitOperationHelper createGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull I18nResolver i18nResolver, @NotNull TrustedKeyHelper trustedKeyHelper) throws RepositoryException {
        if (GitOperationHelperFactory.isNativeGitEnabled(repository)) {
            return new NativeGitOperationHelper(repository, accessData, sshProxyService, buildLogger, i18nResolver, trustedKeyHelper);
        }
        return new JGitOperationHelper(accessData, buildLogger, i18nResolver, trustedKeyHelper);
    }

    public static boolean isNativeGitEnabled(GitRepository repository) {
        return StringUtils.isNotBlank((CharSequence)repository.getGitCapability());
    }
}

