/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public class DeleteGitCacheDirectoryAction
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(DeleteGitCacheDirectoryAction.class);

    public String doExecute() throws Exception {
        final ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            String message = this.getText("repository.git.messages.cache.cleanFailedNoPlan", Arrays.asList(this.getBuildKey()));
            log.error((Object)message);
            this.addActionError(message);
            return "error";
        }
        boolean success = true;
        for (RepositoryDefinition repositoryDefinition : PlanHelper.getRepositoryDefinitions((ImmutablePlan)plan)) {
            Repository repository = repositoryDefinition.getRepository();
            if (!(repository instanceof GitRepository)) {
                String message = this.getText("repository.git.messages.cache.notGit", Arrays.asList(plan.getPlanKey()));
                log.error((Object)message);
                this.addActionError(message);
                return "error";
            }
            GitRepository gitRepository = (GitRepository)repository;
            final File cacheDirectoryFile = gitRepository.getCacheDirectory();
            success = success && "success".equals(GitCacheDirectory.getCacheLock(cacheDirectoryFile).withLock((Supplier)new Supplier<String>(){

                @Override
                public String get() {
                    if (cacheDirectoryFile.exists()) {
                        log.info((Object)DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.cleaning", Arrays.asList(plan.getPlanKey(), cacheDirectoryFile.getAbsolutePath())));
                        try {
                            BambooFileUtils.forceDelete((File)cacheDirectoryFile);
                        }
                        catch (IOException e) {
                            String message = DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.cleanFailed", Arrays.asList(plan.getPlanKey()));
                            log.error((Object)message, (Throwable)e);
                            DeleteGitCacheDirectoryAction.this.addActionError(message);
                            return "error";
                        }
                    } else {
                        String message = DeleteGitCacheDirectoryAction.this.getText("repository.git.messages.cache.notExist", Arrays.asList(plan.getPlanKey(), cacheDirectoryFile.getAbsolutePath()));
                        log.info((Object)message);
                    }
                    return "success";
                }
            }));
        }
        return success ? "success" : "error";
    }
}

