/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.github.api.rest.entity;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;

@XmlRootElement(name="repository")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GitHubRepositoryEntity {
    private static final Logger log = Logger.getLogger(GitHubRepositoryEntity.class);
    @XmlElement(name="full_name")
    private String fullName;

    public static Ordering<GitHubRepositoryEntity> orderingByFullName() {
        return OrderingByFullName.ORDERING;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFullName() {
        return this.fullName;
    }

    public static class Builder {
        private String fullName;

        public Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public GitHubRepositoryEntity build() {
            GitHubRepositoryEntity entity = new GitHubRepositoryEntity();
            entity.fullName = this.fullName;
            return entity;
        }
    }

    private static enum OrderingByFullName implements Comparator<GitHubRepositoryEntity>
    {
        INSTANCE;

        private static final Ordering<GitHubRepositoryEntity> ORDERING;

        @Override
        public int compare(GitHubRepositoryEntity o1, GitHubRepositoryEntity o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getFullName(), (Object)o2.getFullName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }
}

