/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UriUtils {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FTP_SCHEME = "ftp";
    public static final String FTPS_SCHEME = "ftps";
    public static final String FILE_SCHEME = "file";
    static final String SSH_SCHEME = "ssh";
    static final String SCHEME_DELIMITER = "://";
    public static final String SSH_PREFIX = "ssh://";
    @VisibleForTesting
    static final String FAKE_USER = "nouser";
    @VisibleForTesting
    static final String FAKE_PASSWORD = "nopassword";

    private UriUtils() {
    }

    @Nullable
    public static String extractUsername(String repositoryUrl) throws URISyntaxException {
        URIish uri = new URIish(repositoryUrl);
        String auth = uri.getUser();
        if (auth == null) {
            return null;
        }
        return auth;
    }

    public static boolean requiresSshTransport(@NotNull ScpAwareUri repositoryUri) {
        String scheme = repositoryUri.getScheme();
        return scheme != null && scheme.equals(SSH_SCHEME);
    }

    public static boolean requiresSshTransport(@NotNull String repositoryUrl) {
        return repositoryUrl.startsWith(SSH_PREFIX) || UriUtils.hasScpSyntax(repositoryUrl);
    }

    public static boolean hasScpSyntax(@NotNull String url) {
        if (UriUtils.hasScheme(url)) {
            return false;
        }
        int pathDefinitelyStartsHere = url.indexOf("/");
        if (pathDefinitelyStartsHere != -1) {
            url = url.substring(0, pathDefinitelyStartsHere);
        }
        return url.contains(":");
    }

    private static boolean hasScheme(@NotNull String url) {
        int scheme = url.indexOf(SCHEME_DELIMITER);
        return scheme != -1;
    }

    public static URI getUriViaProxy(GitRepositoryAccessData proxyAccessData, ScpAwareUri repositoryUri) throws URISyntaxException {
        return new URI(repositoryUri.getScheme(), proxyAccessData.getProxyRegistrationInfo().getProxyUserName(), proxyAccessData.getProxyRegistrationInfo().getProxyHost(), proxyAccessData.getProxyRegistrationInfo().getProxyPort(), repositoryUri.getAbsolutePath(), repositoryUri.getRawQuery(), repositoryUri.getRawFragment());
    }

    public static URIish normaliseRepositoryLocation(@Nullable String userName, @Nullable String password, @NotNull URIish normalised, boolean shouldAddFakeAuthData) {
        boolean acceptsPasswordInUri;
        String scheme = normalised.getScheme();
        if (UriUtils.isLocalUri(scheme)) {
            return normalised;
        }
        boolean isHttpBased = scheme.equals(HTTP_SCHEME) || scheme.equals(HTTPS_SCHEME);
        boolean isFtpBased = scheme.equals(FTP_SCHEME) || scheme.equals(FTPS_SCHEME);
        boolean bl = acceptsPasswordInUri = isHttpBased || isFtpBased;
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            normalised = UriUtils.setUser(normalised, userName);
        } else {
            String urlUserName = normalised.getUser();
            if (StringUtils.isEmpty((CharSequence)urlUserName)) {
                if (!acceptsPasswordInUri) {
                    return normalised;
                }
                if (shouldAddFakeAuthData) {
                    normalised = UriUtils.setUser(normalised, FAKE_USER);
                }
            }
        }
        if (!acceptsPasswordInUri) {
            return UriUtils.setPassword(normalised, null);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            return UriUtils.setPassword(normalised, password);
        }
        String urlPassword = normalised.getPass();
        boolean hasPasswordInUrl = StringUtils.isNotEmpty((CharSequence)urlPassword);
        return hasPasswordInUrl || !shouldAddFakeAuthData ? normalised : UriUtils.setPassword(normalised, FAKE_PASSWORD);
    }

    private static URIish setPassword(@NotNull URIish normalised, @Nullable String password) {
        return password == null ? normalised.setPass(null) : normalised.setPass(password);
    }

    private static URIish setUser(@NotNull URIish normalised, @Nullable String userName) {
        return userName == null ? normalised.setUser(null) : normalised.setUser(userName);
    }

    private static boolean isLocalUri(@Nullable String scheme) {
        return scheme == null || scheme.equals(FILE_SCHEME);
    }
}

