/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.rest.utils.Get;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubAccessor {
    private static final Logger log = Logger.getLogger(GitHubAccessor.class);
    static final String GITHUB_API_BASE_URL = new SystemProperty(false, new String[]{"atlassian.bamboo.github.api.base.url", "ATLASSIAN_BAMBOO_GITHUB_API_BASE_URL"}).getValue("https://api.github.com/");
    private static final String JSON_ERROR_MESSAGE_FIELD = "message";
    @VisibleForTesting
    static final String QUERY_PARAM_PER_PAGE = "per_page";
    @VisibleForTesting
    static final String QUERY_PARAM_PAGE = "page";
    @VisibleForTesting
    static final int MAX_PAGE_SIZE = 100;
    private final String username;
    private final String password;
    private final boolean onlyPublic;

    public GitHubAccessor(String username, String password) {
        this.username = username;
        this.password = password;
        this.onlyPublic = StringUtils.isBlank((CharSequence)password);
    }

    public Iterable<String> getAccessibleRepositories() throws IOException, GitHubException {
        Iterable<String> userRepos = this.getUserRepositories();
        ArrayList orgRepos = Lists.newArrayList();
        for (String org : this.getUserOrganisations()) {
            Iterables.addAll((Collection)orgRepos, this.getOrganisationRepositories(org));
        }
        return Iterables.concat(userRepos, (Iterable)orgRepos);
    }

    public Map<String, Iterable<String>> getAccessibleRepositoriesAndBranches() throws IOException, GitHubException {
        Iterable<String> accessibleRepositories = this.getAccessibleRepositories();
        LinkedHashMap accessibleRepositoriesAndBranches = Maps.newLinkedHashMap();
        for (String accessibleRepository : accessibleRepositories) {
            accessibleRepositoriesAndBranches.put(accessibleRepository, this.getBranches(accessibleRepository));
        }
        return accessibleRepositoriesAndBranches;
    }

    public Iterable<String> getBranches(String userRepo) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(GITHUB_API_BASE_URL + "repos/" + userRepo + "/branches", "name");
    }

    public Iterable<String> getUserOrganisations() throws IOException, GitHubException {
        Pair<JSONArray, Multimap<String, String>> repoJson = this.getJSONArrayResponseFromUrl(GITHUB_API_BASE_URL + this.getEndPointForCurrentCredentials("orgs"));
        return this.foldArrayAndSort((JSONArray)repoJson.getFirst(), "login");
    }

    private String getEndPointForCurrentCredentials(String endPath) {
        return this.onlyPublic ? "users/" + this.username + "/" + endPath : "user/" + endPath;
    }

    public Iterable<String> getUserRepositories() throws IOException, GitHubException {
        return this.getRepositories(GITHUB_API_BASE_URL + this.getEndPointForCurrentCredentials("repos"));
    }

    public Iterable<String> getOrganisationRepositories(String org) throws IOException, GitHubException {
        return this.getRepositories(GITHUB_API_BASE_URL + "orgs/" + org + "/repos");
    }

    private Iterable<String> getRepositories(String endpoint) throws IOException, GitHubException {
        return this.getFoldedListFromGitHubApi(endpoint, "full_name");
    }

    @NotNull
    @VisibleForTesting
    List<String> getFoldedListFromGitHubApi(@NotNull String endpoint, @NotNull String fieldName) throws IOException, GitHubException {
        String currentEndpoint;
        ArrayList result = Lists.newArrayList();
        try {
            currentEndpoint = GitHubAccessor.appendMaxPageSize(endpoint);
        }
        catch (URISyntaxException e) {
            log.warn((Object)"An invalid URI was used to access GitHub API", (Throwable)e);
            throw new RuntimeException(e);
        }
        while (currentEndpoint != null) {
            Pair<JSONArray, Multimap<String, String>> jsonResponse = this.getJSONArrayResponseFromUrl(currentEndpoint);
            result.addAll(this.foldArrayAndSort((JSONArray)jsonResponse.getFirst(), fieldName));
            currentEndpoint = jsonResponse.getSecond() != null ? this.getNextUrl((Multimap<String, String>)((Multimap)jsonResponse.getSecond())) : null;
        }
        return result;
    }

    @VisibleForTesting
    @Nullable
    String getNextUrl(@NotNull Multimap<String, String> headers) {
        Collection links = headers.get((Object)"Link");
        if (links != null) {
            for (String linkHeader : links) {
                String url = this.extractNextURLFromHeader(linkHeader);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private String extractNextURLFromHeader(String linkHeader) {
        String[] headerParts;
        for (String header : headerParts = linkHeader.split(",")) {
            String[] headerElements = header.split(";");
            String url = "";
            for (String element : headerElements) {
                String trimmed = element.trim().replaceAll("\"", "");
                if (trimmed.startsWith("rel") && trimmed.endsWith("next")) {
                    return url;
                }
                if (!trimmed.startsWith("<") || !trimmed.endsWith(">")) continue;
                url = trimmed.substring(1, trimmed.length() - 1);
            }
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    static String appendMaxPageSize(@NotNull String endpoint) throws URISyntaxException {
        URI endpointUri = new URI(endpoint);
        boolean shouldAppend = true;
        if (StringUtils.isNotEmpty((CharSequence)endpointUri.getQuery())) {
            Multimap queryParams = UrlUtils.extractQueryParams((URI)endpointUri);
            shouldAppend = !queryParams.containsKey((Object)QUERY_PARAM_PER_PAGE) && !queryParams.containsKey((Object)QUERY_PARAM_PAGE);
        }
        return shouldAppend ? new URIBuilder(endpoint).addParameter(QUERY_PARAM_PER_PAGE, Integer.toString(100)).toString() : endpoint;
    }

    @VisibleForTesting
    Pair<JSONArray, Multimap<String, String>> getJSONArrayResponseFromUrl(String url) throws IOException, GitHubException {
        Pair<String, Multimap<String, String>> response = this.getStringFromUrl(url);
        try {
            return Pair.make((Object)new JSONArray((String)response.getFirst()), (Object)response.getSecond());
        }
        catch (JSONException e) {
            JSONObject jsonObject = this.createQuietly((String)response.getFirst());
            if (jsonObject != null && jsonObject.has(JSON_ERROR_MESSAGE_FIELD)) {
                throw new GitHubException(this.getStringQuietly(jsonObject));
            }
            throw new GitHubException(e);
        }
    }

    @Nullable
    private String getStringQuietly(JSONObject jsonObject) {
        try {
            return jsonObject.getString(JSON_ERROR_MESSAGE_FIELD);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    private JSONObject createQuietly(String stringFromUrl) {
        try {
            return new JSONObject(stringFromUrl);
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<String, Multimap<String, String>> getStringFromUrl(String url) throws IOException {
        Get call = new Get(url);
        if (!this.onlyPublic) {
            call.setBasicCredentials(this.username, this.password);
        }
        try {
            call.execute();
            String response = IOUtils.toString((InputStream)call.getResponseAsStream());
            Pair pair = Pair.make((Object)response, (Object)call.getResponseHeaders());
            return pair;
        }
        finally {
            call.release();
        }
    }

    private List<String> foldArrayAndSort(JSONArray repoJson, String field) throws GitHubException {
        return Ordering.natural().sortedCopy(this.foldArray(repoJson, field));
    }

    private Iterable<String> foldArray(JSONArray jsonArray, String field) throws GitHubException {
        try {
            ArrayList repositories = Lists.newArrayList();
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject jsonRepository = jsonArray.getJSONObject(index);
                String repository = jsonRepository.getString(field);
                repositories.add(repository);
            }
            return repositories;
        }
        catch (JSONException e) {
            throw new GitHubException(e);
        }
    }

    public static class GitHubException
    extends Exception {
        public GitHubException(String message) {
            super(message);
        }

        public GitHubException(JSONException e) {
            super((Throwable)e);
        }

        public boolean isAuthError() {
            return this.getMessage().equalsIgnoreCase("Bad credentials");
        }
    }
}

