/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandBuilder {
    private static final Logger log = Logger.getLogger(GitCommandBuilder.class);
    private static final String SSH_ASKPASS_VARIABLE = "SSH_ASKPASS";
    private final List<String> commands = new ArrayList<String>();
    private final Map<String, String> env = Maps.newHashMap();
    private static final Supplier<String> COMMAND_WITH_EMPTY_OUTPUT = Lazy.supplier((Supplier)new Supplier<String>(){

        @Nullable
        public String get() {
            if (SystemUtils.IS_OS_WINDOWS) {
                return "echo";
            }
            for (String file : Lists.newArrayList((Object[])new String[]{"/bin/echo", "/usr/bin/echo"})) {
                if (!new File(file).canExecute()) continue;
                return file;
            }
            log.info((Object)"Unable to find a no-output command for SSH_ASKPASS");
            return null;
        }
    });
    private String executable;
    private String branch;
    private String revision;
    private String source;
    private String destination;
    private String sshKeyFile;
    private String sshCommand;
    private boolean sshCompression;
    private boolean verbose;
    private boolean maxVerboseOutput;
    private boolean shallowClone;

    protected GitCommandBuilder(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
    }

    public GitCommandBuilder executable(String executable) {
        this.executable = executable;
        return this;
    }

    public GitCommandBuilder branch(String branch) {
        this.branch = branch;
        return this;
    }

    public GitCommandBuilder revision(String revision) {
        this.revision = revision;
        return this;
    }

    public GitCommandBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public GitCommandBuilder source(String source) {
        this.source = source;
        return this;
    }

    public GitCommandBuilder verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public GitCommandBuilder sshCommand(String sshCommand) {
        this.sshCommand = sshCommand;
        return this;
    }

    public GitCommandBuilder sshKeyFile(String sshKeyFile) {
        this.sshKeyFile = sshKeyFile;
        return this;
    }

    public GitCommandBuilder sshCompression(boolean sshCompression) {
        this.sshCompression = sshCompression;
        return this;
    }

    public GitCommandBuilder maxVerboseOutput(boolean maxVerboseOutput) {
        this.maxVerboseOutput = maxVerboseOutput;
        return this;
    }

    public GitCommandBuilder shallowClone() {
        this.shallowClone = true;
        return this;
    }

    public GitCommandBuilder append(String argument) {
        this.commands.add(argument);
        return this;
    }

    public GitCommandBuilder env(@Nullable Map<String, String> env) {
        this.env.putAll(env);
        return this;
    }

    public List<String> build() {
        ArrayList<String> commandArgs = new ArrayList<String>();
        if (this.executable != null) {
            commandArgs.add(this.executable);
        } else {
            commandArgs.add("git");
        }
        commandArgs.addAll(this.commands);
        if (this.verbose || this.maxVerboseOutput) {
            commandArgs.add("--verbose");
        }
        if (StringUtils.isNotBlank((CharSequence)this.branch)) {
            commandArgs.add("--branch");
            commandArgs.add(this.branch);
        }
        if (this.revision != null) {
            commandArgs.add("--rev");
            commandArgs.add(this.revision);
        }
        if (this.source != null) {
            commandArgs.add(this.source);
        }
        if (this.destination != null) {
            commandArgs.add(this.destination);
        }
        if (this.shallowClone) {
            commandArgs.add("--depth");
            commandArgs.add("1");
        }
        return commandArgs;
    }

    @NotNull
    public Map<String, String> getEnv() {
        if (StringUtils.isNotBlank((CharSequence)this.sshCommand)) {
            this.env.put("GIT_SSH", this.sshCommand);
        }
        if (System.getenv(SSH_ASKPASS_VARIABLE) == null && !this.env.containsKey(SSH_ASKPASS_VARIABLE)) {
            this.env.put(SSH_ASKPASS_VARIABLE, (String)COMMAND_WITH_EMPTY_OUTPUT.get());
        }
        if (log.isDebugEnabled()) {
            log.debug(this.env);
        }
        return this.env;
    }

    public String toString() {
        return this.build().toString();
    }
}

