/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.rest.resource;

import com.atlassian.bamboo.plugins.git.GitHubAccessor;
import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.plugins.git.github.api.rest.entity.GitHubBranchEntity;
import com.atlassian.bamboo.plugins.git.github.api.rest.entity.GitHubRepositoryEntity;
import com.atlassian.bamboo.plugins.git.rest.entity.ListBranchesResponse;
import com.atlassian.bamboo.plugins.git.rest.entity.ListRepositoriesResponse;
import com.atlassian.bamboo.plugins.git.rest.entity.RestRequest;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.rest.entity.RestResponse;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Path(value="gh")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
public class GitHubResource {
    private static final Logger log = Logger.getLogger(GitHubResource.class);
    private final EncryptionService encryptionService;
    private final I18nResolver i18nResolver;
    private final RepositoryDefinitionManager repositoryDefinitionManager;

    public GitHubResource(EncryptionService encryptionService, I18nResolver i18nResolver, RepositoryDefinitionManager repositoryDefinitionManager) {
        this.encryptionService = encryptionService;
        this.i18nResolver = i18nResolver;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @POST
    @Path(value="repositories/{username}")
    public Response getAvailableRepositories(@Context UriInfo uriInfo, @PathParam(value="username") String username, RestRequest request) {
        if (request.getRepositoryId() > 0L && StringUtils.isBlank((String)request.getPassword())) {
            request.setPassword(this.getRepositoryPassword(request.getRepositoryId()));
        }
        RestResponse.Builder builder = RestResponse.builder();
        try {
            GitHubAccessor gitHubAccessor = new GitHubAccessor(username, request.getPassword());
            ImmutableList repositories = GitHubRepositoryEntity.orderingByFullName().immutableSortedCopy(Iterables.transform(gitHubAccessor.getAccessibleRepositories(), (Function)new Function<String, GitHubRepositoryEntity>(){

                public GitHubRepositoryEntity apply(@Nullable String input) {
                    return GitHubRepositoryEntity.builder().fullName(input).build();
                }
            }));
            ListRepositoriesResponse response = (ListRepositoriesResponse)builder.build(ListRepositoriesResponse.class);
            response.setRepositories((List<GitHubRepositoryEntity>)repositories);
            return Response.ok((Object)((Object)response)).build();
        }
        catch (IOException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
        }
        catch (GitHubAccessor.GitHubException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
        }
        return Response.ok((Object)builder.build(RestResponse.class)).build();
    }

    @POST
    @Path(value="repositories/{owner}/{name}/branches")
    public Response getBranches(@Context UriInfo uriInfo, @PathParam(value="owner") String owner, @PathParam(value="name") String name, RestRequest request) {
        if (request.getRepositoryId() > 0L && StringUtils.isBlank((String)request.getPassword())) {
            request.setPassword(this.getRepositoryPassword(request.getRepositoryId()));
        }
        RestResponse.Builder builder = RestResponse.builder();
        try {
            GitHubAccessor gitHubAccessor = new GitHubAccessor(request.getUsername(), request.getPassword());
            ImmutableList branches = GitHubBranchEntity.orderingByName().immutableSortedCopy(Iterables.transform(gitHubAccessor.getBranches(String.format("%s/%s", owner, name)), (Function)new Function<String, GitHubBranchEntity>(){

                public GitHubBranchEntity apply(@Nullable String input) {
                    return GitHubBranchEntity.builder().name(input).build();
                }
            }));
            ListBranchesResponse response = (ListBranchesResponse)builder.build(ListBranchesResponse.class);
            response.setBranches((List<GitHubBranchEntity>)branches);
            return Response.ok((Object)((Object)response)).build();
        }
        catch (IOException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
        }
        catch (GitHubAccessor.GitHubException e) {
            log.warn((Object)this.i18nResolver.getText("repository.github.ajaxError"), (Throwable)e);
            builder.error(this.i18nResolver.getText("repository.github.ajaxError") + e.toString());
        }
        return Response.ok((Object)builder.build(RestResponse.class)).build();
    }

    @Nullable
    private String getRepositoryPassword(long repositoryId) {
        RepositoryDataImpl repositoryData;
        Repository repository;
        GitHubRepository ghRepository;
        RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
        if (repositoryDataEntity != null && (ghRepository = (GitHubRepository)Narrow.to((Object)(repository = (repositoryData = new RepositoryDataImpl(repositoryDataEntity)).getRepository()), GitHubRepository.class)) != null) {
            return this.encryptionService.decrypt(ghRepository.getEncryptedPassword());
        }
        return null;
    }
}

