/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.transport.URIish;

public class UriUtils {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    static final String SSH_SCHEME = "ssh";
    static final String SCHEME_DELIMITER = "://";
    public static final String SSH_PREFIX = "ssh://";

    private UriUtils() {
    }

    @Nullable
    public static String extractUsername(String repositoryUrl) throws URISyntaxException {
        URIish uri = new URIish(repositoryUrl);
        String auth = uri.getUser();
        if (auth == null) {
            return null;
        }
        return auth;
    }

    public static boolean requiresSshTransport(@NotNull ScpAwareUri repositoryUri) {
        String scheme = repositoryUri.getScheme();
        return scheme != null && scheme.equals(SSH_SCHEME);
    }

    public static boolean requiresSshTransport(@NotNull String repositoryUrl) {
        return repositoryUrl.startsWith(SSH_PREFIX) || UriUtils.hasScpSyntax(repositoryUrl);
    }

    public static boolean hasScpSyntax(@NotNull String url) {
        if (UriUtils.hasScheme(url)) {
            return false;
        }
        int pathDefinitelyStartsHere = url.indexOf("/");
        if (pathDefinitelyStartsHere != -1) {
            url = url.substring(0, pathDefinitelyStartsHere);
        }
        return url.contains(":");
    }

    private static boolean hasScheme(@NotNull String url) {
        int scheme = url.indexOf(SCHEME_DELIMITER);
        return scheme != -1;
    }

    public static URI getUriViaProxy(GitRepositoryAccessData proxyAccessData, ScpAwareUri repositoryUri) throws URISyntaxException {
        return new URI(repositoryUri.getScheme(), proxyAccessData.getProxyRegistrationInfo().getProxyUserName(), proxyAccessData.getProxyRegistrationInfo().getProxyHost(), proxyAccessData.getProxyRegistrationInfo().getProxyPort(), repositoryUri.getAbsolutePath(), repositoryUri.getRawQuery(), repositoryUri.getRawFragment());
    }

    public static URIish normaliseRepositoryLocation(@Nullable String userName, @Nullable String password, @NotNull URIish normalised) {
        boolean isHttpBased;
        if (StringUtils.isNotBlank((String)userName)) {
            normalised = normalised.setUser(userName);
        } else {
            userName = normalised.getUser();
            if (StringUtils.isEmpty((String)userName)) {
                return normalised;
            }
        }
        String scheme = normalised.getScheme();
        boolean bl = isHttpBased = scheme.equals(HTTP_SCHEME) || scheme.equals(HTTPS_SCHEME);
        if (isHttpBased) {
            if (StringUtils.isBlank((String)password)) {
                password = normalised.getPass();
            }
            return normalised.setPass(StringUtils.defaultIfBlank((String)password, (String)"none"));
        }
        return normalised.setPass(null);
    }
}

