/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.ssh.ProxyRegistrationInfo;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public final class GitHubRepositoryAccessData
implements Serializable {
    private String repository;
    private VcsBranch branch;
    private String username;
    private String password;
    private boolean useShallowClones;
    private boolean useSubmodules;
    private int commandTimeout;
    private boolean verboseLogs;
    private transient ProxyRegistrationInfo proxyRegistrationInfo;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NotNull GitHubRepositoryAccessData accessData) {
        return new Builder().clone(accessData);
    }

    public String getRepository() {
        return this.repository;
    }

    @Deprecated
    public String getBranch() {
        return this.branch.getName();
    }

    public VcsBranch getVcsBranch() {
        return this.branch;
    }

    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public ProxyRegistrationInfo getProxyRegistrationInfo() {
        return this.proxyRegistrationInfo;
    }

    public void setProxyRegistrationInfo(ProxyRegistrationInfo proxyRegistrationInfo) {
        this.proxyRegistrationInfo = proxyRegistrationInfo;
    }

    public static final class Builder {
        private String repository;
        private VcsBranch branch;
        private String username;
        private String password;
        private boolean useShallowClones;
        private boolean useSubmodules;
        private int commandTimeout;
        private boolean verboseLogs;

        public Builder clone(GitHubRepositoryAccessData gitRepositoryAccessData) {
            this.repository = gitRepositoryAccessData.repository;
            this.branch = gitRepositoryAccessData.branch;
            this.username = gitRepositoryAccessData.username;
            this.password = gitRepositoryAccessData.password;
            this.useShallowClones = gitRepositoryAccessData.useShallowClones;
            this.useSubmodules = gitRepositoryAccessData.useSubmodules;
            this.commandTimeout = gitRepositoryAccessData.commandTimeout;
            this.verboseLogs = gitRepositoryAccessData.verboseLogs;
            return this;
        }

        public Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        @Deprecated
        public Builder branch(String branch) {
            this.branch = new VcsBranchImpl(branch);
            return this;
        }

        public Builder branch(VcsBranch vcsBranch) {
            this.branch = vcsBranch;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useShallowClones(boolean useShallowClones) {
            this.useShallowClones = useShallowClones;
            return this;
        }

        public Builder useSubmodules(boolean useSubmodules) {
            this.useSubmodules = useSubmodules;
            return this;
        }

        public Builder commandTimeout(int commandTimeout) {
            this.commandTimeout = commandTimeout;
            return this;
        }

        public Builder verboseLogs(boolean verboseLogs) {
            this.verboseLogs = verboseLogs;
            return this;
        }

        public GitHubRepositoryAccessData build() {
            GitHubRepositoryAccessData data = new GitHubRepositoryAccessData();
            data.repository = this.repository;
            data.branch = this.branch;
            data.username = this.username;
            data.password = this.password;
            data.useShallowClones = this.useShallowClones;
            data.useSubmodules = this.useSubmodules;
            data.commandTimeout = this.commandTimeout;
            data.verboseLogs = this.verboseLogs;
            return data;
        }
    }
}

