/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.errors.NotSupportedException;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevObject;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.transport.PushConnection;
import org.shaded.eclipse.jgit.transport.PushResult;
import org.shaded.eclipse.jgit.transport.RemoteRefUpdate;
import org.shaded.eclipse.jgit.transport.TrackingRefUpdate;
import org.shaded.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushProcess {
    static final String PROGRESS_OPENING_CONNECTION = JGitText.get().openingConnection;
    private final Transport transport;
    private PushConnection connection;
    private final Map<String, RemoteRefUpdate> toPush;
    private final RevWalk walker;

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush) throws TransportException {
        this.walker = new RevWalk(transport.local);
        this.transport = transport;
        this.toPush = new HashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : toPush) {
            if (this.toPush.put(rru.getRemoteName(), rru) == null) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, rru.getRemoteName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PushResult execute(ProgressMonitor monitor) throws NotSupportedException, TransportException {
        try {
            monitor.beginTask(PROGRESS_OPENING_CONNECTION, 0);
            PushResult res = new PushResult();
            this.connection = this.transport.openPush();
            try {
                res.setAdvertisedRefs(this.transport.getURI(), this.connection.getRefsMap());
                res.setRemoteUpdates(this.toPush);
                monitor.endTask();
                Map<String, RemoteRefUpdate> preprocessed = this.prepareRemoteUpdates();
                if (this.transport.isDryRun()) {
                    this.modifyUpdatesForDryRun();
                } else if (!preprocessed.isEmpty()) {
                    this.connection.push(monitor, preprocessed);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.connection.close();
                res.addMessages(this.connection.getMessages());
                throw throwable;
            }
            this.connection.close();
            res.addMessages(this.connection.getMessages());
            if (!this.transport.isDryRun()) {
                this.updateTrackingRefs();
            }
            for (RemoteRefUpdate rru : this.toPush.values()) {
                TrackingRefUpdate tru = rru.getTrackingRefUpdate();
                if (tru == null) continue;
                res.add(tru);
            }
            PushResult pushResult = res;
            Object var7_8 = null;
            this.walker.release();
            return pushResult;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.walker.release();
            throw throwable;
        }
    }

    private Map<String, RemoteRefUpdate> prepareRemoteUpdates() throws TransportException {
        HashMap<String, RemoteRefUpdate> result = new HashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : this.toPush.values()) {
            ObjectId advertisedOld;
            Ref advertisedRef = this.connection.getRef(rru.getRemoteName());
            ObjectId objectId = advertisedOld = advertisedRef == null ? ObjectId.zeroId() : advertisedRef.getObjectId();
            if (rru.getNewObjectId().equals(advertisedOld)) {
                if (rru.isDelete()) {
                    rru.setStatus(RemoteRefUpdate.Status.NON_EXISTING);
                    continue;
                }
                rru.setStatus(RemoteRefUpdate.Status.UP_TO_DATE);
                continue;
            }
            if (rru.isExpectingOldObjectId() && !rru.getExpectedOldObjectId().equals(advertisedOld)) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED);
                continue;
            }
            if (advertisedOld.equals(ObjectId.zeroId()) || rru.isDelete()) {
                rru.setFastForward(true);
                result.put(rru.getRemoteName(), rru);
                continue;
            }
            boolean fastForward = true;
            try {
                RevObject oldRev = this.walker.parseAny(advertisedOld);
                RevObject newRev = this.walker.parseAny(rru.getNewObjectId());
                if (!(oldRev instanceof RevCommit && newRev instanceof RevCommit && this.walker.isMergedInto((RevCommit)oldRev, (RevCommit)newRev))) {
                    fastForward = false;
                }
            }
            catch (MissingObjectException x) {
                fastForward = false;
            }
            catch (Exception x) {
                throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, x.getMessage()), x);
            }
            rru.setFastForward(fastForward);
            if (!fastForward && !rru.isForceUpdate()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD);
                continue;
            }
            result.put(rru.getRemoteName(), rru);
        }
        return result;
    }

    private void modifyUpdatesForDryRun() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.OK);
        }
    }

    private void updateTrackingRefs() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            RemoteRefUpdate.Status status = rru.getStatus();
            if (!rru.hasTrackingRefUpdate() || status != RemoteRefUpdate.Status.UP_TO_DATE && status != RemoteRefUpdate.Status.OK) continue;
            try {
                rru.updateTrackingRef(this.walker);
            }
            catch (IOException e) {}
        }
    }
}

