/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.utils.process.LineOutputHandler;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

@NotThreadSafe
public class CommitOutputHandler
extends LineOutputHandler
implements GitCommandProcessor.GitOutputHandler {
    private static final Logger log = Logger.getLogger(CommitOutputHandler.class);
    static final String SALT = "[d31bfa5_BAM_";
    static final String HASH = "[d31bfa5_BAM_hash]";
    static final String COMMITER_NAME = "[d31bfa5_BAM_commiter_name]";
    static final String COMMITER_EMAIL = "[d31bfa5_BAM_commiter_email]";
    static final String TIMESTAMP = "[d31bfa5_BAM_timestamp]";
    static final String COMMIT_MESSAGE = "[d31bfa5_BAM_commit_message]";
    static final String END_OF_COMMIT_MESSAGE = "[d31bfa5_BAM_commit_message_end]";
    static final String FILE_LIST = "[d31bfa5_BAM_file_list]";
    public static final String LOG_COMMAND_FORMAT_STRING = "[d31bfa5_BAM_hash]%H%n[d31bfa5_BAM_commiter_name]%cN%n[d31bfa5_BAM_commiter_email]%ce%n[d31bfa5_BAM_timestamp]%ct%n[d31bfa5_BAM_commit_message]%s%n%b[d31bfa5_BAM_commit_message_end]%n[d31bfa5_BAM_file_list]";
    private List<CommitContext> extractedCommits = Lists.newArrayList();
    private Set<String> shallows;
    private CommitImpl currentCommit = null;
    private String commiterName = null;
    private int skippedCommitCount;
    private int maxCommitNumber;
    private StringBuilder commitMessage = null;
    CommitParserState parserState = CommitParserState.INFO;

    public CommitOutputHandler(@NotNull Set<String> shallows) {
        super("UTF-8");
        this.shallows = shallows;
        this.maxCommitNumber = Integer.MAX_VALUE;
    }

    public CommitOutputHandler(@NotNull Set<String> shallows, int maxCommitNumber) {
        super("UTF-8");
        this.shallows = shallows;
        this.maxCommitNumber = maxCommitNumber;
    }

    @Override
    public String getStdout() {
        return "";
    }

    protected void processLine(int lineNum, String line) {
        if (this.parserState != CommitParserState.TOO_MANY_COMMITS) {
            if (this.parserState != CommitParserState.COMMIT_MESSAGE && line.startsWith(HASH)) {
                if (this.extractedCommits.size() < this.maxCommitNumber) {
                    this.parserState = CommitParserState.INFO;
                    this.currentCommit = new CommitImpl();
                    this.commiterName = null;
                    this.currentCommit.setAuthor((Author)new AuthorImpl("[unknown]"));
                    this.currentCommit.setChangeSetId(this.getLineContent(HASH, line));
                    this.extractedCommits.add((CommitContext)this.currentCommit);
                } else {
                    this.currentCommit = null;
                    this.commiterName = null;
                    ++this.skippedCommitCount;
                    this.parserState = CommitParserState.TOO_MANY_COMMITS;
                }
            }
            if (this.parserState == CommitParserState.COMMIT_MESSAGE) {
                if (line.startsWith(END_OF_COMMIT_MESSAGE)) {
                    if (this.currentCommit != null && this.commitMessage != null) {
                        this.currentCommit.setComment(this.commitMessage.toString());
                        this.commitMessage = null;
                    }
                    this.parserState = CommitParserState.COMMIT_MESSAGE_COMPLETE;
                } else if (line.startsWith(FILE_LIST)) {
                    if (this.currentCommit != null && this.commitMessage != null) {
                        this.currentCommit.setComment(this.commitMessage.substring(0, this.commitMessage.lastIndexOf(END_OF_COMMIT_MESSAGE)));
                        this.commitMessage = null;
                    }
                    this.parserState = CommitParserState.FILE_LIST;
                } else {
                    this.commitMessage.append('\n');
                    this.commitMessage.append(line);
                }
            } else if (this.parserState == CommitParserState.COMMIT_MESSAGE_COMPLETE && line.startsWith(FILE_LIST)) {
                this.parserState = CommitParserState.FILE_LIST;
            } else if (this.parserState == CommitParserState.FILE_LIST && this.currentCommit != null && !StringUtils.isBlank((String)line) && !this.shallows.contains(this.currentCommit.getChangeSetId())) {
                this.currentCommit.addFile((CommitFile)new CommitFileImpl(this.currentCommit.getChangeSetId(), line.trim()));
            } else if (this.parserState == CommitParserState.INFO) {
                if (line.startsWith(COMMITER_NAME)) {
                    if (this.currentCommit != null) {
                        this.commiterName = this.getLineContent(COMMITER_NAME, line);
                    }
                } else if (line.startsWith(COMMITER_EMAIL)) {
                    if (this.currentCommit != null && !StringUtils.isBlank((String)this.commiterName)) {
                        String email = this.getLineContent(COMMITER_EMAIL, line);
                        this.currentCommit.setAuthor((Author)new AuthorImpl(String.format("%s <%s>", this.commiterName, email), null, email));
                    }
                } else if (line.startsWith(TIMESTAMP)) {
                    if (this.currentCommit != null) {
                        String timestampString = this.getLineContent(TIMESTAMP, line);
                        this.currentCommit.setDate(new Date(Long.parseLong(timestampString) * 1000L));
                    }
                } else if (line.startsWith(COMMIT_MESSAGE)) {
                    this.commitMessage = new StringBuilder(this.getLineContent(COMMIT_MESSAGE, line));
                    this.parserState = CommitParserState.COMMIT_MESSAGE;
                }
            }
        } else if (line.startsWith(HASH)) {
            ++this.skippedCommitCount;
        }
    }

    private String getLineContent(String keyword, String line) {
        return line.substring(keyword.length()).trim();
    }

    public List<CommitContext> getExtractedCommits() {
        return this.extractedCommits;
    }

    public int getSkippedCommitCount() {
        return this.skippedCommitCount;
    }

    private static enum CommitParserState {
        INFO,
        COMMIT_MESSAGE,
        COMMIT_MESSAGE_COMPLETE,
        FILE_LIST,
        TOO_MANY_COMMITS;

    }
}

