/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import org.shaded.eclipse.jgit.api.AddCommand;
import org.shaded.eclipse.jgit.api.AddNoteCommand;
import org.shaded.eclipse.jgit.api.BlameCommand;
import org.shaded.eclipse.jgit.api.CheckoutCommand;
import org.shaded.eclipse.jgit.api.CherryPickCommand;
import org.shaded.eclipse.jgit.api.CleanCommand;
import org.shaded.eclipse.jgit.api.CloneCommand;
import org.shaded.eclipse.jgit.api.CommitCommand;
import org.shaded.eclipse.jgit.api.CreateBranchCommand;
import org.shaded.eclipse.jgit.api.DeleteBranchCommand;
import org.shaded.eclipse.jgit.api.DeleteTagCommand;
import org.shaded.eclipse.jgit.api.DiffCommand;
import org.shaded.eclipse.jgit.api.FetchCommand;
import org.shaded.eclipse.jgit.api.InitCommand;
import org.shaded.eclipse.jgit.api.ListBranchCommand;
import org.shaded.eclipse.jgit.api.ListNotesCommand;
import org.shaded.eclipse.jgit.api.ListTagCommand;
import org.shaded.eclipse.jgit.api.LogCommand;
import org.shaded.eclipse.jgit.api.LsRemoteCommand;
import org.shaded.eclipse.jgit.api.MergeCommand;
import org.shaded.eclipse.jgit.api.PullCommand;
import org.shaded.eclipse.jgit.api.PushCommand;
import org.shaded.eclipse.jgit.api.RebaseCommand;
import org.shaded.eclipse.jgit.api.ReflogCommand;
import org.shaded.eclipse.jgit.api.RemoveNoteCommand;
import org.shaded.eclipse.jgit.api.RenameBranchCommand;
import org.shaded.eclipse.jgit.api.ResetCommand;
import org.shaded.eclipse.jgit.api.RevertCommand;
import org.shaded.eclipse.jgit.api.RmCommand;
import org.shaded.eclipse.jgit.api.ShowNoteCommand;
import org.shaded.eclipse.jgit.api.StatusCommand;
import org.shaded.eclipse.jgit.api.TagCommand;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.lib.RepositoryBuilder;
import org.shaded.eclipse.jgit.lib.RepositoryCache;
import org.shaded.eclipse.jgit.util.FS;

public class Git {
    private final Repository repo;

    public static Git open(File dir) throws IOException {
        return Git.open(dir, FS.DETECTED);
    }

    public static Git open(File dir, FS fs) throws IOException {
        RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient(dir, fs);
        return Git.wrap(((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(fs)).setGitDir(key.getFile())).setMustExist(true)).build());
    }

    public static Git wrap(Repository repo) {
        return new Git(repo);
    }

    public static CloneCommand cloneRepository() {
        return new CloneCommand();
    }

    public static InitCommand init() {
        return new InitCommand();
    }

    public Git(Repository repo) {
        if (repo == null) {
            throw new NullPointerException();
        }
        this.repo = repo;
    }

    public CommitCommand commit() {
        return new CommitCommand(this.repo);
    }

    public LogCommand log() {
        return new LogCommand(this.repo);
    }

    public MergeCommand merge() {
        return new MergeCommand(this.repo);
    }

    public PullCommand pull() {
        return new PullCommand(this.repo);
    }

    public CreateBranchCommand branchCreate() {
        return new CreateBranchCommand(this.repo);
    }

    public DeleteBranchCommand branchDelete() {
        return new DeleteBranchCommand(this.repo);
    }

    public ListBranchCommand branchList() {
        return new ListBranchCommand(this.repo);
    }

    public ListTagCommand tagList() {
        return new ListTagCommand(this.repo);
    }

    public RenameBranchCommand branchRename() {
        return new RenameBranchCommand(this.repo);
    }

    public AddCommand add() {
        return new AddCommand(this.repo);
    }

    public TagCommand tag() {
        return new TagCommand(this.repo);
    }

    public FetchCommand fetch() {
        return new FetchCommand(this.repo);
    }

    public PushCommand push() {
        return new PushCommand(this.repo);
    }

    public CherryPickCommand cherryPick() {
        return new CherryPickCommand(this.repo);
    }

    public RevertCommand revert() {
        return new RevertCommand(this.repo);
    }

    public RebaseCommand rebase() {
        return new RebaseCommand(this.repo);
    }

    public RmCommand rm() {
        return new RmCommand(this.repo);
    }

    public CheckoutCommand checkout() {
        return new CheckoutCommand(this.repo);
    }

    public ResetCommand reset() {
        return new ResetCommand(this.repo);
    }

    public StatusCommand status() {
        return new StatusCommand(this.repo);
    }

    public AddNoteCommand notesAdd() {
        return new AddNoteCommand(this.repo);
    }

    public RemoveNoteCommand notesRemove() {
        return new RemoveNoteCommand(this.repo);
    }

    public ListNotesCommand notesList() {
        return new ListNotesCommand(this.repo);
    }

    public ShowNoteCommand notesShow() {
        return new ShowNoteCommand(this.repo);
    }

    public LsRemoteCommand lsRemote() {
        return new LsRemoteCommand(this.repo);
    }

    public CleanCommand clean() {
        return new CleanCommand(this.repo);
    }

    public BlameCommand blame() {
        return new BlameCommand(this.repo);
    }

    public ReflogCommand reflog() {
        return new ReflogCommand(this.repo);
    }

    public DiffCommand diff() {
        return new DiffCommand(this.repo);
    }

    public DeleteTagCommand tagDelete() {
        return new DeleteTagCommand(this.repo);
    }

    public Repository getRepository() {
        return this.repo;
    }
}

