/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import org.shaded.eclipse.jgit.revwalk.Generator;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevFlag;

abstract class AbstractRevQueue
extends Generator {
    static final AbstractRevQueue EMPTY_QUEUE = new AlwaysEmptyQueue();
    int outputType;

    AbstractRevQueue() {
    }

    public abstract void add(RevCommit var1);

    public final void add(RevCommit c, RevFlag queueControl) {
        if (!c.has(queueControl)) {
            c.add(queueControl);
            this.add(c);
        }
    }

    public final void addParents(RevCommit c, RevFlag queueControl) {
        RevCommit[] pList = c.parents;
        if (pList == null) {
            return;
        }
        for (RevCommit p : pList) {
            this.add(p, queueControl);
        }
    }

    public abstract RevCommit next();

    public abstract void clear();

    abstract boolean everbodyHasFlag(int var1);

    abstract boolean anybodyHasFlag(int var1);

    int outputType() {
        return this.outputType;
    }

    protected static void describe(StringBuilder s, RevCommit c) {
        s.append(c.toString());
        s.append('\n');
    }

    private static class AlwaysEmptyQueue
    extends AbstractRevQueue {
        private AlwaysEmptyQueue() {
        }

        public void add(RevCommit c) {
            throw new UnsupportedOperationException();
        }

        public RevCommit next() {
            return null;
        }

        boolean anybodyHasFlag(int f) {
            return false;
        }

        boolean everbodyHasFlag(int f) {
            return true;
        }

        public void clear() {
        }
    }
}

