/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.core.TransportProtocol;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.BranchIntegrationHelper;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitMavenPomAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.PushCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteBuildDirectoryManager;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.RequirementsAwareRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.transport.URIish;

public class GitRepository
extends AbstractStandaloneRepository
implements MavenPomAccessorCapableRepository,
SelectableAuthenticationRepository,
CustomVariableProviderRepository,
CustomSourceDirectoryAwareRepository,
RequirementsAwareRepository,
AdvancedConfigurationAwareRepository,
BranchDetectionCapableRepository,
PushCapableRepository,
CachingAwareRepository,
BranchMergingAwareRepository {
    private static final String REPOSITORY_GIT_NAME = "repository.git.name";
    private static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
    private static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
    private static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
    private static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    private static final String REPOSITORY_GIT_BRANCH = "repository.git.branch";
    private static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
    private static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
    private static final String REPOSITORY_GIT_USE_SHALLOW_CLONES = "repository.git.useShallowClones";
    private static final String REPOSITORY_GIT_USE_SUBMODULES = "repository.git.useSubmodules";
    private static final String REPOSITORY_GIT_MAVEN_PATH = "repository.git.maven.path";
    private static final String REPOSITORY_GIT_COMMAND_TIMEOUT = "repository.git.commandTimeout";
    private static final String REPOSITORY_GIT_VERBOSE_LOGS = "repository.git.verbose.logs";
    private static final String TEMPORARY_GIT_PASSWORD = "temporary.git.password";
    private static final String TEMPORARY_GIT_PASSWORD_CHANGE = "temporary.git.password.change";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE = "temporary.git.ssh.passphrase";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE = "temporary.git.ssh.passphrase.change";
    private static final String TEMPORARY_GIT_SSH_KEY_FROM_FILE = "temporary.git.ssh.keyfile";
    private static final String TEMPORARY_GIT_SSH_KEY_CHANGE = "temporary.git.ssh.key.change";
    private static final GitAuthenticationType defaultAuthenticationType = GitAuthenticationType.NONE;
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    static final int DEFAULT_COMMAND_TIMEOUT_IN_MINUTES = 180;
    private static final Logger log = Logger.getLogger(GitRepository.class);
    private BranchIntegrationHelper branchIntegrationHelper;
    private VcsBranch branch;
    private GitRepositoryAccessData accessData = new GitRepositoryAccessData();
    private transient String pathToPom;
    private transient CapabilityContext capabilityContext;
    private transient I18nResolver i18nResolver;
    private transient SshProxyService sshProxyService;
    private transient EncryptionService encryptionService;

    @NotNull
    public String getName() {
        return this.i18nResolver.getText(REPOSITORY_GIT_NAME);
    }

    public String getHost() {
        return "";
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitRepository) {
            GitRepository gitRepo = (GitRepository)repository;
            return !new EqualsBuilder().append((Object)this.accessData.getRepositoryUrl(), (Object)gitRepo.accessData.getRepositoryUrl()).append((Object)this.accessData.getBranch(), (Object)gitRepo.accessData.getBranch()).append((Object)this.accessData.getUsername(), (Object)gitRepo.accessData.getUsername()).append((Object)this.accessData.getSshKey(), (Object)gitRepo.accessData.getSshKey()).isEquals();
        }
        return true;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey.getKey(), targetRevision, targetRevision);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey, lastVcsRevisionKey, null);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, final @Nullable String lastVcsRevisionKey, @Nullable String customRevision) throws RepositoryException {
        try {
            String targetRevision;
            final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(PlanKeys.getPlanKey((String)planKey));
            final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
            final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver);
            String latestRevision = helper.obtainLatestRevision();
            final String fetchRevision = customRevision != null ? customRevision : substitutedAccessData.getBranch();
            String string = targetRevision = customRevision != null ? customRevision : latestRevision;
            if (latestRevision.equals(lastVcsRevisionKey) && customRevision == null) {
                return new BuildRepositoryChangesImpl(latestRevision);
            }
            final File cacheDirectory = this.getCacheDirectory();
            if (lastVcsRevisionKey == null) {
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.ccRepositoryNeverChecked", new Serializable[]{fetchRevision}));
                try {
                    GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws RepositoryException {
                            boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.isUseShallowClones() && !cacheDirectory.isDirectory();
                            helper.fetch(cacheDirectory, fetchRevision, doShallowFetch);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                return new BuildRepositoryChangesImpl(targetRevision);
            }
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Supplier)new Supplier<BuildRepositoryChanges>(){

                public BuildRepositoryChanges get() {
                    try {
                        helper.fetch(cacheDirectory, fetchRevision, false);
                        return helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                    }
                    catch (Exception e) {
                        try {
                            GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.ccRecover.failedToCollectChangesets");
                            buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                            helper.fetch(cacheDirectory, fetchRevision, false);
                            buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", new Serializable[]{cacheDirectory}));
                            BuildRepositoryChanges extractedChanges = helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                            buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.ccRecover.completed"));
                            return extractedChanges;
                        }
                        catch (Exception e2) {
                            log.error((Object)buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                            return null;
                        }
                    }
                }
            });
            if (buildChanges != null && !buildChanges.getChanges().isEmpty()) {
                return buildChanges;
            }
            return new BuildRepositoryChangesImpl(latestRevision, Collections.singletonList(CommitContextImpl.builder().author("[unknown]").comment(this.i18nResolver.getText("repository.git.messages.unknownChanges", new Serializable[]{lastVcsRevisionKey, targetRevision})).date(new Date()).build()));
        }
        catch (RuntimeException e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        return this.retrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, final @NotNull File sourceDirectory, int depth) throws RepositoryException {
        GitRepositoryAccessData.Builder substitutedAccessDataBuilder = this.getSubstitutedAccessDataBuilder();
        final boolean doShallowFetch = USE_SHALLOW_CLONES && this.accessData.isUseShallowClones() && depth == 1;
        substitutedAccessDataBuilder.useShallowClones(doShallowFetch);
        GitRepositoryAccessData substitutedAccessData = substitutedAccessDataBuilder.build();
        final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(buildContext.getPlanResultKey());
        final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver);
        final String targetRevision = vcsRevisionKey != null ? vcsRevisionKey : helper.obtainLatestRevision();
        final String fetchRevision = substitutedAccessData.getBranch();
        final String previousRevision = helper.getRevisionIfExists(sourceDirectory, "HEAD");
        if (this.isOnLocalAgent()) {
            final File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
            return (String)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        helper.fetch(cacheDirectory, fetchRevision, doShallowFetch && !cacheDirectory.isDirectory());
                        helper.checkRevisionExistsInCacheRepository(cacheDirectory, targetRevision);
                    }
                    catch (Exception e) {
                        GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                        buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                        helper.fetch(cacheDirectory, fetchRevision, false);
                        buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", new Serializable[]{cacheDirectory}));
                    }
                    try {
                        return helper.checkout(cacheDirectory, sourceDirectory, targetRevision, previousRevision);
                    }
                    catch (Exception e) {
                        GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                        buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{sourceDirectory}));
                        String returnRevision = helper.checkout(cacheDirectory, sourceDirectory, targetRevision, null);
                        buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                        return returnRevision;
                    }
                }
            });
        }
        {
            catch (Exception e) {
                throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
            }
            try {
                helper.fetch(sourceDirectory, targetRevision, doShallowFetch);
                return helper.checkout(null, sourceDirectory, targetRevision, previousRevision);
            }
            catch (Exception e) {}
            {
                this.rethrowOrRemoveDirectory(e, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{sourceDirectory}));
                helper.fetch(sourceDirectory, targetRevision, false);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCompleted", new Serializable[]{sourceDirectory}));
                String returnRevision = helper.checkout(null, sourceDirectory, targetRevision, null);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                return returnRevision;
            }
        }
    }

    private boolean isOnLocalAgent() {
        return !(this.buildDirectoryManager instanceof RemoteBuildDirectoryManager);
    }

    @Deprecated
    @NotNull
    public List<VcsBranch> getOpenBranches() throws RepositoryException {
        return this.getOpenBranches(null);
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver);
        return helper.getOpenBranches(substitutedAccessData, this.getWorkingDirectory());
    }

    public void pushRevision(@NotNull File sourceDirectory, @Nullable String vcsRevisionKey) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver);
        helper.pushRevision(sourceDirectory, vcsRevisionKey);
    }

    @NotNull
    public String commit(@NotNull File sourceDirectory, @NotNull String message) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver);
        return helper.commit(sourceDirectory, message, this.branchIntegrationHelper.getCommitterName((Repository)this), this.branchIntegrationHelper.getCommitterEmail((Repository)this));
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
                return new CacheId((Repository)this, new String[]{substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUsername(), substitutedAccessData.getSshKey()});
            }
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return this.branch;
    }

    public void setVcsBranch(@NotNull VcsBranch branch) {
        this.branch = branch;
        this.accessData = GitRepositoryAccessData.builder(this.accessData).branch(branch.getName()).build();
    }

    public boolean mergeWorkspaceWith(@NotNull BuildContext buildContext, @NotNull File workspaceDir, final @NotNull String targetRevision) throws RepositoryException {
        final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(PlanKeys.getPlanKey((String)buildContext.getPlanKey()));
        boolean doShallowFetch = false;
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder().useShallowClones(false).build();
        final GitOperationHelper connector = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver);
        final File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        try {
            if (this.isOnLocalAgent()) {
                GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            connector.fetch(cacheDirectory, targetRevision, false);
                            connector.checkRevisionExistsInCacheRepository(cacheDirectory, targetRevision);
                        }
                        catch (Exception e) {
                            GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                            buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", new Serializable[]{cacheDirectory}));
                            connector.fetch(cacheDirectory, targetRevision, false);
                            buildLogger.addBuildLogEntry(GitRepository.this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", new Serializable[]{cacheDirectory}));
                        }
                        return null;
                    }
                });
            } else {
                try {
                    connector.fetch(workspaceDir, targetRevision, false);
                }
                catch (Exception e) {
                    this.rethrowOrRemoveDirectory(e, buildLogger, workspaceDir, "repository.git.messages.rsRecover.failedToFetchWorkingDir");
                    buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{workspaceDir}));
                    connector.fetch(workspaceDir, targetRevision, false);
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
        return connector.merge(workspaceDir, targetRevision, this.branchIntegrationHelper.getCommitterName((Repository)this), this.branchIntegrationHelper.getCommitterEmail((Repository)this));
    }

    public boolean isMergingSupported() {
        return GitOperationHelperFactory.isNativeGitEnabled(this);
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        return null;
    }

    public CommitContext getLastCommit() throws RepositoryException {
        NullBuildLogger buildLogger = new NullBuildLogger();
        final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)buildLogger, this.i18nResolver);
        final String targetRevision = helper.obtainLatestRevision();
        final File cacheDirectory = this.getCacheDirectory();
        Result result = (Result)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Supplier)new Supplier<Result<RepositoryException, CommitContext>>(){

            public Result<RepositoryException, CommitContext> get() {
                boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.isUseShallowClones() && !cacheDirectory.isDirectory();
                try {
                    CommitContext commit = helper.getCommit(cacheDirectory, targetRevision);
                    log.info((Object)("Found " + commit.getChangeSetId() + " as the last commit for " + this));
                    return Result.result((Object)commit);
                }
                catch (RepositoryException e) {
                    try {
                        log.debug((Object)"Fetching remote repository");
                        helper.fetch(cacheDirectory, targetRevision, doShallowFetch);
                        return Result.result((Object)helper.getCommit(cacheDirectory, targetRevision));
                    }
                    catch (RepositoryException e2) {
                        return Result.exception((Throwable)e2);
                    }
                }
            }
        });
        return (CommitContext)result.getResultThrowException();
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)180);
        buildConfiguration.clearTree(REPOSITORY_GIT_VERBOSE_LOGS);
        buildConfiguration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)true);
        buildConfiguration.clearTree(REPOSITORY_GIT_USE_SUBMODULES);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)buildConfiguration.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180));
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.encryptionService.encrypt(buildConfiguration.getString(TEMPORARY_GIT_PASSWORD)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.encryptionService.encrypt(buildConfiguration.getString(TEMPORARY_GIT_SSH_PASSPHRASE)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(TEMPORARY_GIT_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                String key;
                try {
                    key = FileUtils.readFileToString((File)((File)o));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
                buildConfiguration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.encryptionService.encrypt(key));
            } else {
                buildConfiguration.clearProperty(REPOSITORY_GIT_SSH_KEY);
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.accessData = GitRepositoryAccessData.builder().repositoryUrl(StringUtils.trimToEmpty((String)config.getString(REPOSITORY_GIT_REPOSITORY_URL))).username(config.getString(REPOSITORY_GIT_USERNAME, "")).password(config.getString(REPOSITORY_GIT_PASSWORD)).branch(config.getString(REPOSITORY_GIT_BRANCH, "")).sshKey(config.getString(REPOSITORY_GIT_SSH_KEY, "")).sshPassphrase(config.getString(REPOSITORY_GIT_SSH_PASSPHRASE)).authenticationType(this.safeParseAuthenticationType(config.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE))).useShallowClones(config.getBoolean(REPOSITORY_GIT_USE_SHALLOW_CLONES)).useSubmodules(config.getBoolean(REPOSITORY_GIT_USE_SUBMODULES, false)).commandTimeout(config.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180)).verboseLogs(config.getBoolean(REPOSITORY_GIT_VERBOSE_LOGS, false)).build();
        this.branch = new VcsBranchImpl(StringUtils.defaultIfEmpty((String)this.accessData.getBranch(), (String)"master"));
        this.pathToPom = config.getString(REPOSITORY_GIT_MAVEN_PATH);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GIT_REPOSITORY_URL, (Object)this.accessData.getRepositoryUrl());
        configuration.setProperty(REPOSITORY_GIT_USERNAME, (Object)this.accessData.getUsername());
        configuration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.accessData.getPassword());
        configuration.setProperty(REPOSITORY_GIT_BRANCH, (Object)this.accessData.getBranch());
        configuration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.accessData.getSshKey());
        configuration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.accessData.getSshPassphrase());
        configuration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, (Object)this.accessData.getAuthenticationTypeString());
        configuration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)this.accessData.isUseShallowClones());
        configuration.setProperty(REPOSITORY_GIT_USE_SUBMODULES, (Object)this.accessData.isUseSubmodules());
        configuration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)this.accessData.getCommandTimeout());
        configuration.setProperty(REPOSITORY_GIT_VERBOSE_LOGS, (Object)this.accessData.isVerboseLogs());
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection;
        block13: {
            errorCollection = super.validate(buildConfiguration);
            String repositoryUrl = StringUtils.trim((String)buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL));
            GitAuthenticationType authenticationType = this.safeParseAuthenticationType(buildConfiguration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
            if (StringUtils.isBlank((String)repositoryUrl)) {
                errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, this.i18nResolver.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                TransportProtocol transportProtocol = TransportProtocol.of((String)repositoryUrl, (TransportProtocol)TransportProtocol.SSH);
                if (!this.featureManager.isTransportSupported(transportProtocol)) {
                    errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, TextProviderUtils.getText((I18nResolver)this.i18nResolver, (String)"repository.git.messages.unsupportedTransportProtocol", (String[])new String[]{transportProtocol.toString()}));
                }
                boolean hasUsername = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_USERNAME));
                boolean hasPassword = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_PASSWORD));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
                        errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.i18nResolver.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        boolean duplicatePassword;
                        boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((String)uri.getUser());
                        boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((String)uri.getPass());
                        if (duplicateUsername || duplicatePassword) {
                            errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, (duplicateUsername ? this.i18nResolver.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.i18nResolver.getText("repository.git.messages.duplicatePasswordField") : ""));
                        }
                        if (duplicateUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.i18nResolver.getText("repository.git.messages.duplicateUsernameField"));
                        }
                        if (duplicatePassword) {
                            errorCollection.addError(TEMPORARY_GIT_PASSWORD_CHANGE, this.i18nResolver.getText("repository.git.messages.duplicatePasswordField"));
                        }
                        if (uri.getHost() == null && hasUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block13;
                    errorCollection.addError(REPOSITORY_GIT_USERNAME, this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        if (buildConfiguration.getString(REPOSITORY_GIT_MAVEN_PATH, "").contains("..")) {
            errorCollection.addError(REPOSITORY_GIT_MAVEN_PATH, this.i18nResolver.getText("repository.git.messages.invalidPomPath"));
        }
        return errorCollection;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        HashMap variables = Maps.newHashMap();
        variables.put(REPOSITORY_GIT_REPOSITORY_URL, this.accessData.getRepositoryUrl());
        variables.put(REPOSITORY_GIT_BRANCH, this.accessData.getBranch());
        variables.put(REPOSITORY_GIT_USERNAME, this.accessData.getUsername());
        return variables;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new GitMavenPomAccessor(this, this.sshProxyService, this.i18nResolver, this.getGitCapability()).withPath(this.pathToPom);
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Lists.transform(Arrays.asList(GitAuthenticationType.values()), (Function)new Function<GitAuthenticationType, NameValuePair>(){

            public NameValuePair apply(GitAuthenticationType from) {
                String typeName = from.name();
                return new NameValuePair(typeName, GitRepository.this.getAuthTypeName(typeName));
            }
        });
    }

    public String getAuthType() {
        return this.accessData.getAuthenticationTypeString();
    }

    GitAuthenticationType safeParseAuthenticationType(String typeName) {
        if (typeName == null) {
            return defaultAuthenticationType;
        }
        try {
            return GitAuthenticationType.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            return defaultAuthenticationType;
        }
    }

    String getAuthTypeName(String authType) {
        return this.i18nResolver.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    GitRepositoryAccessData.Builder getSubstitutedAccessDataBuilder() {
        return GitRepositoryAccessData.builder(this.accessData).repositoryUrl(this.substituteString(this.accessData.getRepositoryUrl())).branch(this.substituteString(this.accessData.getBranch())).username(this.substituteString(this.accessData.getUsername())).password(this.encryptionService.decrypt(this.accessData.getPassword())).sshKey(this.encryptionService.decrypt(this.accessData.getSshKey())).sshPassphrase(this.encryptionService.decrypt(this.accessData.getSshPassphrase()));
    }

    GitRepositoryAccessData getSubstitutedAccessData() {
        return this.getSubstitutedAccessDataBuilder().build();
    }

    private void rethrowOrRemoveDirectory(Exception originalException, BuildLogger buildLogger, File directory, String key) throws Exception {
        Throwable e = originalException;
        do {
            if (!(e instanceof TransportException)) continue;
            throw originalException;
        } while ((e = e.getCause()) != null);
        buildLogger.addBuildLogEntry(this.i18nResolver.getText(key, new Serializable[]{directory}));
        log.warn((Object)("Deleting directory " + directory), e);
        FileUtils.deleteQuietly((File)directory);
        Object[] filesInDirectory = directory.list();
        if (filesInDirectory != null) {
            log.error((Object)("Unable to delete files: " + Arrays.toString(filesInDirectory) + ", expect trouble"));
        }
    }

    public boolean isUseShallowClones() {
        return this.accessData.isUseShallowClones();
    }

    public boolean isUseSubmodules() {
        return this.accessData.isUseSubmodules();
    }

    public String getRepositoryUrl() {
        return this.accessData.getRepositoryUrl();
    }

    @Deprecated
    public String getBranch() {
        return this.accessData.getBranch();
    }

    public int getCommandTimeout() {
        return this.accessData.getCommandTimeout();
    }

    public boolean getVerboseLogs() {
        return this.accessData.isVerboseLogs();
    }

    public String getAuthTypeName() {
        return this.getAuthTypeName(this.getAuthType());
    }

    public File getCacheDirectory() {
        return this.getCacheDirectory(this.getSubstitutedAccessData());
    }

    public File getCacheDirectory(GitRepositoryAccessData accessData) {
        return GitCacheDirectory.getCacheDirectory(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), accessData);
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public String getOptionDescription() {
        String capabilitiesLink = ServletActionContext.getRequest().getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        return this.i18nResolver.getText("repository.git.description", new Serializable[]{this.getGitCapability(), capabilitiesLink});
    }

    public Set<Requirement> getRequirements() {
        return Sets.newHashSet();
    }

    @Nullable
    public String getGitCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable");
    }

    @Nullable
    public String getSshCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable.ssh");
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    public void setBranchIntegrationHelper(BranchIntegrationHelper branchIntegrationHelper) {
        this.branchIntegrationHelper = branchIntegrationHelper;
    }

    public GitRepositoryAccessData getAccessData() {
        return this.accessData;
    }

    public void setAccessData(GitRepositoryAccessData accessData) {
        this.accessData = accessData;
    }
}

