/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.util.Arrays;
import org.shaded.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.shaded.eclipse.jgit.transport.CredentialItem;
import org.shaded.eclipse.jgit.transport.CredentialsProvider;
import org.shaded.eclipse.jgit.transport.URIish;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String username, String password) {
        this(username, password.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(this.username);
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(this.password);
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getPromptText());
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

