/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.revwalk.RevWalk;

public class RevFlag {
    public static final RevFlag UNINTERESTING = new StaticRevFlag("UNINTERESTING", 4);
    final RevWalk walker;
    final String name;
    final int mask;

    RevFlag(RevWalk w, String n, int m) {
        this.walker = w;
        this.name = n;
        this.mask = m;
    }

    public RevWalk getRevWalk() {
        return this.walker;
    }

    public String toString() {
        return this.name;
    }

    static class StaticRevFlag
    extends RevFlag {
        StaticRevFlag(String n, int m) {
            super(null, n, m);
        }

        public RevWalk getRevWalk() {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().isAStaticFlagAndHasNorevWalkInstance, this.toString()));
        }
    }
}

