/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.lib.Constants;
import org.shaded.eclipse.jgit.lib.ProgressMonitor;
import org.shaded.eclipse.jgit.storage.pack.ObjectToPack;
import org.shaded.eclipse.jgit.storage.pack.PackWriter;
import org.shaded.eclipse.jgit.util.NB;

public final class PackOutputStream
extends OutputStream {
    private static final int BYTES_TO_WRITE_BEFORE_CANCEL_CHECK = 131072;
    private final ProgressMonitor writeMonitor;
    private final OutputStream out;
    private final PackWriter packWriter;
    private final CRC32 crc = new CRC32();
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;
    private byte[] headerBuffer = new byte[32];
    private byte[] copyBuffer;
    private long checkCancelAt;

    public PackOutputStream(ProgressMonitor writeMonitor, OutputStream out, PackWriter pw) {
        this.writeMonitor = writeMonitor;
        this.out = out;
        this.packWriter = pw;
        this.checkCancelAt = 131072L;
    }

    public void write(int b) throws IOException {
        ++this.count;
        this.out.write(b);
        this.crc.update(b);
        this.md.update((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (0 < len) {
            int n = Math.min(len, 131072);
            this.count += (long)n;
            if (this.checkCancelAt <= this.count) {
                if (this.writeMonitor.isCancelled()) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
                this.checkCancelAt = this.count + 131072L;
            }
            this.out.write(b, off, n);
            this.crc.update(b, off, n);
            this.md.update(b, off, n);
            off += n;
            len -= n;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    void writeFileHeader(int version, long objectCount) throws IOException {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, version);
        NB.encodeInt32(this.headerBuffer, 8, (int)objectCount);
        this.write(this.headerBuffer, 0, 12);
    }

    public void writeObject(ObjectToPack otp) throws IOException {
        this.packWriter.writeObject(this, otp);
    }

    public void writeHeader(ObjectToPack otp, long rawLength) throws IOException {
        if (otp.isDeltaRepresentation()) {
            ObjectToPack baseInPack;
            if (this.packWriter.isDeltaBaseAsOffset() && (baseInPack = otp.getDeltaBase()) != null && baseInPack.isWritten()) {
                long start = this.count;
                int n = this.encodeTypeSize(6, rawLength);
                this.write(this.headerBuffer, 0, n);
                long offsetDiff = start - baseInPack.getOffset();
                n = this.headerBuffer.length - 1;
                this.headerBuffer[n] = (byte)(offsetDiff & 0x7FL);
                while ((offsetDiff >>= 7) > 0L) {
                    this.headerBuffer[--n] = (byte)(0x80L | --offsetDiff & 0x7FL);
                }
                this.write(this.headerBuffer, n, this.headerBuffer.length - n);
                return;
            }
            int n = this.encodeTypeSize(7, rawLength);
            otp.getDeltaBaseId().copyRawTo(this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n + 20);
        } else {
            int n = this.encodeTypeSize(otp.getType(), rawLength);
            this.write(this.headerBuffer, 0, n);
        }
    }

    private int encodeTypeSize(int type, long rawLength) {
        long nextLength = rawLength >>> 4;
        this.headerBuffer[0] = (byte)((long)((nextLength > 0L ? 128 : 0) | type << 4) | rawLength & 0xFL);
        rawLength = nextLength;
        int n = 1;
        while (rawLength > 0L) {
            this.headerBuffer[n++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | rawLength & 0x7FL);
            rawLength = nextLength;
        }
        return n;
    }

    public byte[] getCopyBuffer() {
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[16384];
        }
        return this.copyBuffer;
    }

    void endObject() {
        this.writeMonitor.update(1);
    }

    public long length() {
        return this.count;
    }

    int getCRC32() {
        return (int)this.crc.getValue();
    }

    void resetCRC32() {
        this.crc.reset();
    }

    byte[] getDigest() {
        return this.md.digest();
    }
}

