/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.util.Map;
import org.shaded.eclipse.jgit.merge.ResolveMerger;
import org.shaded.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseResult {
    static final RebaseResult OK_RESULT = new RebaseResult(Status.OK);
    static final RebaseResult ABORTED_RESULT = new RebaseResult(Status.ABORTED);
    static final RebaseResult UP_TO_DATE_RESULT = new RebaseResult(Status.UP_TO_DATE);
    static final RebaseResult FAST_FORWARD_RESULT = new RebaseResult(Status.FAST_FORWARD);
    private final Status mySatus;
    private final RevCommit currentCommit;
    private Map<String, ResolveMerger.MergeFailureReason> failingPaths;

    private RebaseResult(Status status) {
        this.mySatus = status;
        this.currentCommit = null;
    }

    RebaseResult(RevCommit commit) {
        this.mySatus = Status.STOPPED;
        this.currentCommit = commit;
    }

    RebaseResult(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        this.mySatus = Status.FAILED;
        this.currentCommit = null;
        this.failingPaths = failingPaths;
    }

    public Status getStatus() {
        return this.mySatus;
    }

    public RevCommit getCurrentCommit() {
        return this.currentCommit;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ABORTED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STOPPED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        FAILED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UP_TO_DATE{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD{

            public boolean isSuccessful() {
                return true;
            }
        };


        public abstract boolean isSuccessful();
    }
}

