/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.IOException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.transport.RefSpec;

public class TrackingRefUpdate {
    private final String remoteName;
    private final RefUpdate update;

    TrackingRefUpdate(Repository db, RefSpec spec, AnyObjectId nv, String msg) throws IOException {
        this(db, spec.getDestination(), spec.getSource(), spec.isForceUpdate(), nv, msg);
    }

    TrackingRefUpdate(Repository db, String localName, String remoteName, boolean forceUpdate, AnyObjectId nv, String msg) throws IOException {
        this.remoteName = remoteName;
        this.update = db.updateRef(localName);
        this.update.setForceUpdate(forceUpdate);
        this.update.setNewObjectId(nv);
        this.update.setRefLogMessage(msg, true);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getLocalName() {
        return this.update.getName();
    }

    public ObjectId getNewObjectId() {
        return this.update.getNewObjectId();
    }

    public ObjectId getOldObjectId() {
        return this.update.getOldObjectId();
    }

    public RefUpdate.Result getResult() {
        return this.update.getResult();
    }

    void update(RevWalk walk) throws IOException {
        this.update.update(walk);
    }

    void delete(RevWalk walk) throws IOException {
        this.update.delete(walk);
    }
}

