/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.revwalk;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.treewalk.filter.PathFilter;
import org.shaded.eclipse.jgit.treewalk.filter.TreeFilter;

public class FollowFilter
extends TreeFilter {
    private final PathFilter path;

    public static FollowFilter create(String path) {
        return new FollowFilter(PathFilter.create(path));
    }

    FollowFilter(PathFilter path) {
        this.path = path;
    }

    public String getPath() {
        return this.path.getPath();
    }

    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker) && ANY_DIFF.include(walker);
    }

    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    public TreeFilter clone() {
        return new FollowFilter(this.path.clone());
    }

    public String toString() {
        return "(FOLLOW(" + this.path.toString() + ")" + " AND " + ANY_DIFF.toString() + ")";
    }
}

