/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCommandBuilder;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.ScpAwareUri;
import com.atlassian.bamboo.plugins.git.UriUtils;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.ProxyException;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.storage.file.FileRepository;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.Transport;

public class NativeGitOperationHelper
extends GitOperationHelper {
    private static final Logger log = Logger.getLogger(GitRepository.class);
    private static final String GIT_SCHEME = "git";
    protected SshProxyService sshProxyService;
    GitCommandProcessor gitCommandProcessor;

    public NativeGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepository.GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider) throws RepositoryException {
        super(accessData, buildLogger, textProvider);
        this.sshProxyService = sshProxyService;
        this.gitCommandProcessor = new GitCommandProcessor(repository.getGitCapability(), buildLogger, accessData.commandTimeout, accessData.verboseLogs);
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory());
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    @Override
    public void pushRevision(@NotNull File sourceDirectory, @NotNull String revision) throws RepositoryException {
        String possibleBranch = this.gitCommandProcessor.getPossibleBranchNameForCheckout(sourceDirectory, revision);
        if (StringUtils.isBlank((String)possibleBranch)) {
            throw new RepositoryException("Can't guess branch name for revision " + revision + " when trying to perform push.");
        }
        GitRepository.GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("push", proxiedAccessData.repositoryUrl, possibleBranch);
        if (proxiedAccessData.verboseLogs) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
    }

    @Override
    public String commit(@NotNull File sourceDirectory, @NotNull String message, @NotNull String comitterName, @NotNull String comitterEmail) throws RepositoryException {
        if (!this.containsSomethingToCommit(sourceDirectory)) {
            log.debug((Object)"Nothing to commit");
            return this.getCurrentRevision(sourceDirectory);
        }
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("commit", "-m", message, "--all").env((Map<String, String>)this.identificationVariables(comitterName, comitterEmail));
        if (this.accessData.verboseLogs) {
            commandBuilder.verbose(true);
        }
        this.gitCommandProcessor.runCommand(commandBuilder, sourceDirectory);
        return this.getCurrentRevision(sourceDirectory);
    }

    public ImmutableMap<String, String> identificationVariables(@NotNull String name, @NotNull String email) {
        return ImmutableMap.of((Object)"GIT_COMMITTER_NAME", (Object)name, (Object)"GIT_COMMITTER_EMAIL", (Object)email, (Object)"GIT_AUTHOR_NAME", (Object)name, (Object)"GIT_AUTHOR_EMAIL", (Object)email);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFetch(@NotNull Transport transport, @NotNull File sourceDirectory, RefSpec refSpec, boolean useShallow) throws RepositoryException {
        GitRepository.GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        try {
            this.gitCommandProcessor.runFetchCommand(sourceDirectory, proxiedAccessData, refSpec, useShallow);
        }
        finally {
            this.closeProxy(proxiedAccessData);
        }
    }

    @Override
    protected String doCheckout(@NotNull FileRepository localRepository, @NotNull File sourceDirectory, @NotNull String branchRefSpec, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        this.gitCommandProcessor.runCheckoutCommand(sourceDirectory, targetRevision);
        if (useSubmodules) {
            this.gitCommandProcessor.runSubmoduleUpdateCommand(sourceDirectory);
        }
        return targetRevision;
    }

    protected GitRepository.GitRepositoryAccessData adjustRepositoryAccess(@NotNull GitRepository.GitRepositoryAccessData accessData) throws RepositoryException {
        boolean needsProxy;
        boolean bl = needsProxy = accessData.authenticationType == GitAuthenticationType.SSH_KEYPAIR || UriUtils.isSsh(accessData.repositoryUrl) && accessData.authenticationType == GitAuthenticationType.PASSWORD;
        if (needsProxy) {
            GitRepository.GitRepositoryAccessData proxyAccessData = accessData.cloneAccessData();
            ScpAwareUri repositoryUri = ScpAwareUri.create(proxyAccessData.repositoryUrl);
            if (GIT_SCHEME.equals(repositoryUri.getScheme()) || UriUtils.isSsh(repositoryUri)) {
                try {
                    String username = UriUtils.extractUsername(proxyAccessData.repositoryUrl);
                    if (username != null) {
                        proxyAccessData.username = username;
                    }
                    ProxyConnectionDataBuilder proxyConnectionDataBuilder = this.sshProxyService.createProxyConnectionDataBuilder().withRemoteAddress(repositoryUri.getHost(), repositoryUri.getPort() == -1 ? 22 : repositoryUri.getPort()).withRemoteUserName(StringUtils.defaultIfEmpty((String)proxyAccessData.username, (String)repositoryUri.getUserInfo())).withErrorReceiver((ProxyErrorReceiver)this.gitCommandProcessor);
                    if (repositoryUri.isRelativePath()) {
                        proxyConnectionDataBuilder.withRemotePathMapping(repositoryUri.getAbsolutePath(), repositoryUri.getRawPath());
                    }
                    switch (accessData.authenticationType) {
                        case SSH_KEYPAIR: {
                            proxyConnectionDataBuilder.withKeyFromString(proxyAccessData.sshKey, proxyAccessData.sshPassphrase);
                            break;
                        }
                        case PASSWORD: {
                            proxyConnectionDataBuilder.withRemotePassword(StringUtils.defaultString((String)proxyAccessData.password));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Proxy does not know how to handle " + (Object)((Object)accessData.authenticationType));
                        }
                    }
                    ProxyConnectionData connectionData = proxyConnectionDataBuilder.build();
                    proxyAccessData.proxyRegistrationInfo = this.sshProxyService.register(connectionData);
                    URI repositoryViaProxy = UriUtils.getUriViaProxy(proxyAccessData, repositoryUri);
                    proxyAccessData.repositoryUrl = repositoryViaProxy.toString();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("exception using cipher - please check password and data.")) {
                        throw new RepositoryException(this.buildLogger.addErrorLogEntry("Encryption exception - please check ssh keyfile passphrase."), (Throwable)e);
                    }
                    throw new RepositoryException("Cannot decode connection params", (Throwable)e);
                }
                catch (ProxyException e) {
                    throw new RepositoryException("Cannot create SSH proxy", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    throw new RepositoryException("Remote repository URL invalid", (Throwable)e);
                }
                return proxyAccessData;
            }
        } else if (accessData.authenticationType == GitAuthenticationType.PASSWORD) {
            GitRepository.GitRepositoryAccessData credentialsAwareAccessData = accessData.cloneAccessData();
            URI repositoryUrl = this.wrapWithUsernameAndPassword(credentialsAwareAccessData);
            credentialsAwareAccessData.repositoryUrl = repositoryUrl.toString();
            return credentialsAwareAccessData;
        }
        return accessData;
    }

    @Override
    public boolean merge(@NotNull File workspaceDir, @NotNull String targetRevision, @NotNull String committerName, @NotNull String committerEmail) throws RepositoryException {
        GitCommandBuilder commandBuilder = this.gitCommandProcessor.createCommandBuilder("merge", "--no-commit", targetRevision).env((Map<String, String>)this.identificationVariables(committerName, committerEmail));
        String headRevisionBeforeMerge = this.getCurrentRevision(workspaceDir);
        this.gitCommandProcessor.runMergeCommand(commandBuilder, workspaceDir);
        if (this.containsSomethingToCommit(workspaceDir)) {
            return true;
        }
        String headRevisionAfterMerge = this.getCurrentRevision(workspaceDir);
        log.debug((Object)("Revision before merge: " + headRevisionBeforeMerge + ", after merge: " + headRevisionAfterMerge));
        return !headRevisionAfterMerge.equals(headRevisionBeforeMerge);
    }

    private boolean containsSomethingToCommit(@NotNull File workspaceDir) throws RepositoryException {
        boolean hasModifiedFiles;
        String mergeHead = this.getRevisionIfExists(workspaceDir, "MERGE_HEAD");
        if (mergeHead != null) {
            log.debug((Object)"Has modified index");
            return true;
        }
        List<String> strings = this.gitCommandProcessor.runStatusCommand(workspaceDir);
        boolean bl = hasModifiedFiles = !strings.isEmpty();
        if (hasModifiedFiles) {
            log.debug((Object)"Has modified files");
        }
        return hasModifiedFiles;
    }

    @NotNull
    private URI wrapWithUsernameAndPassword(GitRepository.GitRepositoryAccessData repositoryAccessData) {
        try {
            URI remoteUri = new URI(repositoryAccessData.repositoryUrl);
            return new URI(remoteUri.getScheme(), this.getAuthority(repositoryAccessData), remoteUri.getHost(), remoteUri.getPort(), remoteUri.getPath(), remoteUri.getQuery(), remoteUri.getFragment());
        }
        catch (URISyntaxException e) {
            String message = "Cannot parse remote URI: " + repositoryAccessData.repositoryUrl;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private String getAuthority(GitRepository.GitRepositoryAccessData repositoryAccessData) {
        boolean isHttpBased;
        boolean passwordAuthentication;
        String username = repositoryAccessData.username;
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        String repositoryUrl = repositoryAccessData.repositoryUrl;
        boolean bl = passwordAuthentication = repositoryAccessData.authenticationType == GitAuthenticationType.PASSWORD;
        if (!passwordAuthentication || UriUtils.isSsh(repositoryUrl)) {
            return username;
        }
        String password = repositoryAccessData.password;
        boolean bl2 = isHttpBased = repositoryUrl.startsWith("http://") || repositoryUrl.startsWith("https://");
        if (isHttpBased && StringUtils.isBlank((String)password)) {
            password = "none";
        }
        return StringUtils.isNotBlank((String)password) ? username + ":" + password : username;
    }

    protected void closeProxy(@NotNull GitRepository.GitRepositoryAccessData accessData) {
        this.sshProxyService.unregister(accessData.proxyRegistrationInfo);
    }
}

