/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.transport;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.transport.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnection
implements Connection {
    private Map<String, Ref> advertisedRefs = Collections.emptyMap();
    private boolean startedOperation;
    private Writer messageWriter;

    @Override
    public Map<String, Ref> getRefsMap() {
        return this.advertisedRefs;
    }

    @Override
    public final Collection<Ref> getRefs() {
        return this.advertisedRefs.values();
    }

    @Override
    public final Ref getRef(String name) {
        return this.advertisedRefs.get(name);
    }

    @Override
    public String getMessages() {
        return this.messageWriter != null ? this.messageWriter.toString() : "";
    }

    @Override
    public abstract void close();

    protected void available(Map<String, Ref> all) {
        this.advertisedRefs = Collections.unmodifiableMap(all);
    }

    protected void markStartedOperation() throws TransportException {
        if (this.startedOperation) {
            throw new TransportException(JGitText.get().onlyOneOperationCallPerConnectionIsSupported);
        }
        this.startedOperation = true;
    }

    protected Writer getMessageWriter() {
        if (this.messageWriter == null) {
            this.setMessageWriter(new StringWriter());
        }
        return this.messageWriter;
    }

    protected void setMessageWriter(Writer writer) {
        if (this.messageWriter != null) {
            throw new IllegalStateException(JGitText.get().writerAlreadyInitialized);
        }
        this.messageWriter = writer;
    }
}

