/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.atlassian.bamboo.ssh.ProxyException;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.storage.file.FileRepository;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.Transport;
import org.shaded.eclipse.jgit.transport.URIish;

public class NativeGitOperationHelper
extends GitOperationHelper {
    private static final Logger log = Logger.getLogger(NativeGitOperationHelper.class);
    protected SshProxyService sshProxyService;
    protected GitCommandProcessor gitCommandProcessor;

    public NativeGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepository.GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider) throws RepositoryException {
        super(accessData, buildLogger, textProvider);
        this.sshProxyService = sshProxyService;
        this.gitCommandProcessor = new GitCommandProcessor(repository.getGitCapability(), buildLogger, accessData.commandTimeout, accessData.verboseLogs);
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory());
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFetch(@NotNull Transport transport, @NotNull File sourceDirectory, RefSpec refSpec, boolean useShallow) throws RepositoryException {
        GitRepository.GitRepositoryAccessData proxiedAccessData = this.adjustRepositoryAccess(this.accessData);
        try {
            this.gitCommandProcessor.runFetchCommand(sourceDirectory, proxiedAccessData, refSpec, useShallow);
        }
        finally {
            this.closeProxy(proxiedAccessData);
        }
    }

    @Override
    protected String doCheckout(@NotNull FileRepository localRepository, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        this.gitCommandProcessor.runCheckoutCommand(sourceDirectory, targetRevision);
        if (useSubmodules) {
            this.gitCommandProcessor.runSubmoduleUpdateCommand(sourceDirectory);
        }
        return targetRevision;
    }

    protected GitRepository.GitRepositoryAccessData adjustRepositoryAccess(@NotNull GitRepository.GitRepositoryAccessData accessData) throws RepositoryException {
        if (accessData.authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
            URI repositoryUri;
            GitRepository.GitRepositoryAccessData proxyAccessData = accessData.cloneAccessData();
            if (!StringUtils.contains((String)proxyAccessData.repositoryUrl, (String)"://")) {
                proxyAccessData.repositoryUrl = "ssh://" + proxyAccessData.repositoryUrl.replaceFirst(":", "/");
            }
            if ("git".equals((repositoryUri = URI.create(proxyAccessData.repositoryUrl)).getScheme()) || "ssh".equals(repositoryUri.getScheme())) {
                try {
                    String username = this.extractUsername(proxyAccessData.repositoryUrl);
                    if (username != null) {
                        proxyAccessData.username = username;
                    }
                    ProxyConnectionData connectionData = this.sshProxyService.createProxyConnectionDataBuilder().withRemoteAddress(repositoryUri.getHost(), repositoryUri.getPort() == -1 ? 22 : repositoryUri.getPort()).withRemoteUserName(StringUtils.defaultIfEmpty((String)proxyAccessData.username, (String)repositoryUri.getUserInfo())).withErrorReceiver((ProxyErrorReceiver)this.gitCommandProcessor).withKeyFromString(proxyAccessData.sshKey, proxyAccessData.sshPassphrase).build();
                    proxyAccessData.proxyRegistrationInfo = this.sshProxyService.register(connectionData);
                    URI cooked = new URI(repositoryUri.getScheme(), proxyAccessData.proxyRegistrationInfo.getProxyUserName(), proxyAccessData.proxyRegistrationInfo.getProxyHost(), proxyAccessData.proxyRegistrationInfo.getProxyPort(), repositoryUri.getRawPath(), repositoryUri.getRawQuery(), repositoryUri.getRawFragment());
                    proxyAccessData.repositoryUrl = cooked.toString();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("exception using cipher - please check password and data.")) {
                        throw new RepositoryException(this.buildLogger.addErrorLogEntry("Encryption exception - please check ssh keyfile passphrase."), (Throwable)e);
                    }
                    throw new RepositoryException("Cannot decode connection params", (Throwable)e);
                }
                catch (ProxyException e) {
                    throw new RepositoryException("Cannot create SSH proxy", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    throw new RepositoryException("Remote repository URL invalid", (Throwable)e);
                }
                return proxyAccessData;
            }
        } else if (accessData.authenticationType == GitAuthenticationType.PASSWORD) {
            GitRepository.GitRepositoryAccessData credentialsAwareAccessData = accessData.cloneAccessData();
            URI repositoryUrl = this.wrapWithUsernameAndPassword(credentialsAwareAccessData);
            credentialsAwareAccessData.repositoryUrl = repositoryUrl.toString();
            return credentialsAwareAccessData;
        }
        return accessData;
    }

    @Override
    public boolean merge(@NotNull File workspaceDir, @NotNull String targetRevision) throws RepositoryException {
        return this.gitCommandProcessor.runMergeCommand(workspaceDir, targetRevision);
    }

    @Nullable
    private String extractUsername(String repositoryUrl) throws URISyntaxException {
        URIish uri = new URIish(repositoryUrl);
        String auth = uri.getUser();
        if (auth == null) {
            return null;
        }
        return auth;
    }

    @NotNull
    private URI wrapWithUsernameAndPassword(GitRepository.GitRepositoryAccessData repositoryAccessData) {
        try {
            boolean usePassword;
            String username = repositoryAccessData.username;
            String password = repositoryAccessData.password;
            boolean bl = usePassword = repositoryAccessData.authenticationType == GitAuthenticationType.PASSWORD && StringUtils.isNotBlank((String)password);
            String authority = StringUtils.isEmpty((String)username) ? null : (usePassword ? username + ":" + password : username);
            URI remoteUri = new URI(repositoryAccessData.repositoryUrl);
            return new URI(remoteUri.getScheme(), authority, remoteUri.getHost(), remoteUri.getPort(), remoteUri.getPath(), remoteUri.getQuery(), remoteUri.getFragment());
        }
        catch (URISyntaxException e) {
            String message = "Cannot parse remote URI: " + repositoryAccessData.repositoryUrl;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void closeProxy(@NotNull GitRepository.GitRepositoryAccessData accessData) {
        this.sshProxyService.unregister(accessData.proxyRegistrationInfo);
    }
}

