/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.git.BuildLoggerProgressMonitor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.dircache.DirCache;
import org.shaded.eclipse.jgit.dircache.DirCacheCheckout;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.RefUpdate;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.storage.file.FileRepository;
import org.shaded.eclipse.jgit.transport.FetchResult;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.TagOpt;
import org.shaded.eclipse.jgit.transport.Transport;

public class JGitOperationHelper
extends GitOperationHelper {
    private static final Logger log = Logger.getLogger(JGitOperationHelper.class);

    public JGitOperationHelper(GitRepository.GitRepositoryAccessData accessData, @NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider) {
        super(accessData, buildLogger, textProvider);
    }

    @Override
    protected void doFetch(@NotNull Transport transport, @NotNull File sourceDirectory, RefSpec refSpec, boolean useShallow) throws RepositoryException {
        String branchDescription = "(unresolved) " + this.accessData.branch;
        try {
            transport.setTagOpt(TagOpt.AUTO_FOLLOW);
            FetchResult fetchResult = transport.fetch(new BuildLoggerProgressMonitor(this.buildLogger), Arrays.asList(refSpec), useShallow ? 1 : 0);
            this.buildLogger.addBuildLogEntry("Git: " + fetchResult.getMessages());
        }
        catch (IOException e) {
            String message = this.textProvider.getText("repository.git.messages.fetchingFailed", Arrays.asList(this.accessData.repositoryUrl, branchDescription, sourceDirectory));
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }

    @Override
    protected String doCheckout(@NotNull FileRepository localRepository, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        if (useSubmodules) {
            this.buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry(this.textProvider.getText("repository.git.messages.jgit.submodules.not.supported")));
        }
        RevWalk revWalk = null;
        DirCache dirCache = null;
        try {
            dirCache = localRepository.lockDirCache();
            revWalk = new RevWalk(localRepository);
            RevCommit targetCommit = revWalk.parseCommit(localRepository.resolve(targetRevision));
            RevCommit previousCommit = previousRevision == null ? null : revWalk.parseCommit(localRepository.resolve(previousRevision));
            DirCacheCheckout dirCacheCheckout = new DirCacheCheckout((Repository)localRepository, previousCommit == null ? null : previousCommit.getTree(), dirCache, targetCommit.getTree());
            dirCacheCheckout.setFailOnConflict(true);
            try {
                dirCacheCheckout.checkout();
            }
            catch (MissingObjectException e) {
                String message = this.textProvider.getText("repository.git.messages.checkoutFailedMissingObject", Arrays.asList(targetRevision, e.getObjectId().getName()));
                throw new RepositoryException(this.buildLogger.addErrorLogEntry(message));
            }
            RefUpdate refUpdate = localRepository.updateRef("HEAD");
            refUpdate.setNewObjectId(targetCommit);
            refUpdate.forceUpdate();
            String string = targetCommit.getId().getName();
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(this.buildLogger.addErrorLogEntry(this.textProvider.getText("repository.git.messages.checkoutFailed", Arrays.asList(targetRevision))) + e.getMessage(), (Throwable)e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
            if (dirCache != null) {
                dirCache.unlock();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
    }

    @Override
    public boolean merge(File workspaceDir, String targetRevision) {
        throw new UnsupportedOperationException("JGit implementation does not support merging, please use native Git");
    }
}

