/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitMavenPomAccessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.security.StringEncrypter;
import com.atlassian.bamboo.ssh.ProxyRegistrationInfo;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteBuildDirectoryManager;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.RequirementsAwareRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.errors.TransportException;
import org.shaded.eclipse.jgit.transport.URIish;

public class GitRepository
extends AbstractStandaloneRepository
implements MavenPomAccessorCapableRepository,
SelectableAuthenticationRepository,
CustomVariableProviderRepository,
CustomSourceDirectoryAwareRepository,
RequirementsAwareRepository,
AdvancedConfigurationAwareRepository {
    private static final String REPOSITORY_GIT_NAME = "repository.git.name";
    private static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
    private static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
    private static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
    private static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    private static final String REPOSITORY_GIT_BRANCH = "repository.git.branch";
    private static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
    private static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
    private static final String REPOSITORY_GIT_USE_SHALLOW_CLONES = "repository.git.useShallowClones";
    private static final String REPOSITORY_GIT_USE_SUBMODULES = "repository.git.useSubmodules";
    private static final String REPOSITORY_GIT_MAVEN_PATH = "repository.git.maven.path";
    private static final String REPOSITORY_GIT_COMMAND_TIMEOUT = "repository.git.commandTimeout";
    private static final String REPOSITORY_GIT_VERBOSE_LOGS = "repository.git.verbose.logs";
    private static final String TEMPORARY_GIT_PASSWORD = "temporary.git.password";
    private static final String TEMPORARY_GIT_PASSWORD_CHANGE = "temporary.git.password.change";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE = "temporary.git.ssh.passphrase";
    private static final String TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE = "temporary.git.ssh.passphrase.change";
    private static final String TEMPORARY_GIT_SSH_KEY_FROM_FILE = "temporary.git.ssh.keyfile";
    private static final String TEMPORARY_GIT_SSH_KEY_CHANGE = "temporary.git.ssh.key.change";
    private static final GitAuthenticationType defaultAuthenticationType = GitAuthenticationType.NONE;
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    static final int DEFAULT_COMMAND_TIMEOUT_IN_MINUTES = 180;
    private static final Logger log = Logger.getLogger(GitRepository.class);
    public final GitRepositoryAccessData accessData = new GitRepositoryAccessData();
    private transient String pathToPom;
    private final transient LazyReference<StringEncrypter> encrypterRef = new LazyReference<StringEncrypter>(){

        protected StringEncrypter create() throws Exception {
            return new StringEncrypter();
        }
    };
    private transient CapabilityContext capabilityContext;
    private transient SshProxyService sshProxyService;

    @NotNull
    public String getName() {
        return this.textProvider.getText(REPOSITORY_GIT_NAME);
    }

    public String getHost() {
        return null;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof GitRepository) {
            GitRepository gitRepo = (GitRepository)repository;
            return !new EqualsBuilder().append((Object)this.accessData.repositoryUrl, (Object)gitRepo.accessData.repositoryUrl).append((Object)this.accessData.branch, (Object)gitRepo.accessData.branch).append((Object)this.accessData.username, (Object)gitRepo.accessData.username).append((Object)this.accessData.sshKey, (Object)gitRepo.accessData.sshKey).isEquals();
        }
        return true;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, final @Nullable String lastVcsRevisionKey) throws RepositoryException {
        try {
            final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
            final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(PlanKeys.getPlanKey((String)planKey));
            final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.textProvider);
            final String targetRevision = helper.obtainLatestRevision(substitutedAccessData);
            if (targetRevision.equals(lastVcsRevisionKey)) {
                return new BuildRepositoryChangesImpl(targetRevision);
            }
            final File cacheDirectory = this.getCacheDirectory();
            if (lastVcsRevisionKey == null) {
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.ccRepositoryNeverChecked", Arrays.asList(targetRevision)));
                try {
                    GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws RepositoryException {
                            boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.useShallowClones && !cacheDirectory.isDirectory();
                            helper.fetch(cacheDirectory, substitutedAccessData, doShallowFetch);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                return new BuildRepositoryChangesImpl(targetRevision);
            }
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Supplier)new Supplier<BuildRepositoryChanges>(){

                public BuildRepositoryChanges get() {
                    try {
                        helper.fetch(cacheDirectory, substitutedAccessData, false);
                        return helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                    }
                    catch (Exception e) {
                        try {
                            GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.ccRecover.failedToCollectChangesets");
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.cleanedCacheDirectory", Arrays.asList(cacheDirectory)));
                            helper.fetch(cacheDirectory, substitutedAccessData, false);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.fetchedRemoteRepository", Arrays.asList(cacheDirectory)));
                            BuildRepositoryChanges extractedChanges = helper.extractCommits(cacheDirectory, lastVcsRevisionKey, targetRevision);
                            buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.completed"));
                            return extractedChanges;
                        }
                        catch (Exception e2) {
                            log.error((Object)buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.ccRecover.failedToExtractChangesets")), (Throwable)e2);
                            return null;
                        }
                    }
                }
            });
            if (buildChanges != null && !buildChanges.getChanges().isEmpty()) {
                return buildChanges;
            }
            return new BuildRepositoryChangesImpl(targetRevision, Collections.singletonList(CommitContextImpl.builder().author("[unknown]").comment(this.textProvider.getText("repository.git.messages.unknownChanges", Arrays.asList(lastVcsRevisionKey, targetRevision))).date(new Date()).build()));
        }
        catch (RuntimeException e) {
            throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    @Deprecated
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey) throws RepositoryException {
        throw new NotImplementedException("Not implemented - use instead retrieveSourceCode(bctx, rev, src)");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String nullableTargetRevision, final @NotNull File sourceDirectory) throws RepositoryException {
        final GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData();
        final BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(buildContext.getPlanResultKey());
        final boolean doShallowFetch = USE_SHALLOW_CLONES && substitutedAccessData.useShallowClones;
        boolean isOnLocalAgent = !(this.buildDirectoryManager instanceof RemoteBuildDirectoryManager);
        final GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.textProvider);
        final String targetRevision = nullableTargetRevision != null ? nullableTargetRevision : helper.obtainLatestRevision(substitutedAccessData);
        final String previousRevision = helper.getCurrentRevision(sourceDirectory);
        if (isOnLocalAgent) {
            final File cacheDirectory = this.getCacheDirectory();
            return (String)GitCacheDirectory.getCacheLock(cacheDirectory).withLock((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        helper.fetch(cacheDirectory, substitutedAccessData, doShallowFetch);
                        helper.checkRevisionExistsInCacheRepository(cacheDirectory, targetRevision);
                    }
                    catch (Exception e) {
                        GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, cacheDirectory, "repository.git.messages.rsRecover.failedToFetchCache");
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.cleanedCacheDirectory", Arrays.asList(cacheDirectory)));
                        helper.fetch(cacheDirectory, substitutedAccessData, false);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.fetchingCacheCompleted", Arrays.asList(cacheDirectory)));
                    }
                    try {
                        return helper.checkout(cacheDirectory, sourceDirectory, targetRevision, previousRevision, GitRepository.this.accessData.useSubmodules);
                    }
                    catch (Exception e) {
                        GitRepository.this.rethrowOrRemoveDirectory(e, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", Arrays.asList(sourceDirectory)));
                        String returnRevision = helper.checkout(cacheDirectory, sourceDirectory, targetRevision, null, GitRepository.this.accessData.useSubmodules);
                        buildLogger.addBuildLogEntry(GitRepository.this.textProvider.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                        return returnRevision;
                    }
                }
            });
        }
        {
            catch (Exception e) {
                throw new RepositoryException(this.textProvider.getText("repository.git.messages.runtimeException"), (Throwable)e);
            }
            try {
                helper.fetch(sourceDirectory, substitutedAccessData, doShallowFetch);
                return helper.checkout(null, sourceDirectory, targetRevision, previousRevision, this.accessData.useSubmodules);
            }
            catch (Exception e) {}
            {
                this.rethrowOrRemoveDirectory(e, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", Arrays.asList(sourceDirectory)));
                helper.fetch(sourceDirectory, substitutedAccessData, false);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.fetchingCompleted", Arrays.asList(sourceDirectory)));
                String returnRevision = helper.checkout(null, sourceDirectory, targetRevision, null, this.accessData.useSubmodules);
                buildLogger.addBuildLogEntry(this.textProvider.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                return returnRevision;
            }
        }
    }

    private void rethrowOrRemoveDirectory(Exception originalException, BuildLogger buildLogger, File directory, String key) throws Exception {
        Throwable e = originalException;
        do {
            if (!(e instanceof TransportException)) continue;
            throw originalException;
        } while ((e = e.getCause()) != null);
        buildLogger.addBuildLogEntry(this.textProvider.getText(key, Arrays.asList(directory)));
        log.warn((Object)("Deleting directory " + directory), e);
        FileUtils.deleteQuietly((File)directory);
        Object[] filesInDirectory = directory.list();
        if (filesInDirectory != null) {
            log.error((Object)("Unable to delete files: " + Arrays.toString(filesInDirectory) + ", expect trouble"));
        }
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)180);
        buildConfiguration.clearTree(REPOSITORY_GIT_VERBOSE_LOGS);
        buildConfiguration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)true);
        buildConfiguration.clearTree(REPOSITORY_GIT_USE_SUBMODULES);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)buildConfiguration.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180));
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_PASSWORD_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)((StringEncrypter)this.encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_PASSWORD)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_PASSPHRASE_CHANGE)) {
            buildConfiguration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)((StringEncrypter)this.encrypterRef.get()).encrypt(buildConfiguration.getString(TEMPORARY_GIT_SSH_PASSPHRASE)));
        }
        if (buildConfiguration.getBoolean(TEMPORARY_GIT_SSH_KEY_CHANGE)) {
            Object o = buildConfiguration.getProperty(TEMPORARY_GIT_SSH_KEY_FROM_FILE);
            if (o instanceof File) {
                String key;
                try {
                    key = FileUtils.readFileToString((File)((File)o));
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                    return;
                }
                buildConfiguration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)((StringEncrypter)this.encrypterRef.get()).encrypt(key));
            } else {
                buildConfiguration.clearProperty(REPOSITORY_GIT_SSH_KEY);
            }
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.accessData.repositoryUrl = StringUtils.trimToEmpty((String)config.getString(REPOSITORY_GIT_REPOSITORY_URL));
        this.accessData.username = config.getString(REPOSITORY_GIT_USERNAME, "");
        this.accessData.password = config.getString(REPOSITORY_GIT_PASSWORD);
        this.accessData.branch = config.getString(REPOSITORY_GIT_BRANCH, "");
        this.accessData.sshKey = config.getString(REPOSITORY_GIT_SSH_KEY, "");
        this.accessData.sshPassphrase = config.getString(REPOSITORY_GIT_SSH_PASSPHRASE);
        this.accessData.authenticationType = this.safeParseAuthenticationType(config.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
        this.accessData.useShallowClones = config.getBoolean(REPOSITORY_GIT_USE_SHALLOW_CLONES);
        this.accessData.useSubmodules = config.getBoolean(REPOSITORY_GIT_USE_SUBMODULES, false);
        this.accessData.commandTimeout = config.getInt(REPOSITORY_GIT_COMMAND_TIMEOUT, 180);
        this.accessData.verboseLogs = config.getBoolean(REPOSITORY_GIT_VERBOSE_LOGS, false);
        this.pathToPom = config.getString(REPOSITORY_GIT_MAVEN_PATH);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(REPOSITORY_GIT_REPOSITORY_URL, (Object)this.accessData.repositoryUrl);
        configuration.setProperty(REPOSITORY_GIT_USERNAME, (Object)this.accessData.username);
        configuration.setProperty(REPOSITORY_GIT_PASSWORD, (Object)this.accessData.password);
        configuration.setProperty(REPOSITORY_GIT_BRANCH, (Object)this.accessData.branch);
        configuration.setProperty(REPOSITORY_GIT_SSH_KEY, (Object)this.accessData.sshKey);
        configuration.setProperty(REPOSITORY_GIT_SSH_PASSPHRASE, (Object)this.accessData.sshPassphrase);
        configuration.setProperty(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : null);
        configuration.setProperty(REPOSITORY_GIT_USE_SHALLOW_CLONES, (Object)this.accessData.useShallowClones);
        configuration.setProperty(REPOSITORY_GIT_USE_SUBMODULES, (Object)this.accessData.useSubmodules);
        configuration.setProperty(REPOSITORY_GIT_COMMAND_TIMEOUT, (Object)this.accessData.commandTimeout);
        configuration.setProperty(REPOSITORY_GIT_VERBOSE_LOGS, (Object)this.accessData.verboseLogs);
        return configuration;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection;
        block12: {
            errorCollection = super.validate(buildConfiguration);
            String repositoryUrl = StringUtils.trim((String)buildConfiguration.getString(REPOSITORY_GIT_REPOSITORY_URL));
            GitAuthenticationType authenticationType = this.safeParseAuthenticationType(buildConfiguration.getString(REPOSITORY_GIT_AUTHENTICATION_TYPE));
            if (StringUtils.isBlank((String)repositoryUrl)) {
                errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, this.textProvider.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                boolean hasUsername = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_USERNAME));
                boolean hasPassword = StringUtils.isNotBlank((String)buildConfiguration.getString(REPOSITORY_GIT_PASSWORD));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
                        errorCollection.addError(REPOSITORY_GIT_AUTHENTICATION_TYPE, this.textProvider.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        boolean duplicatePassword;
                        boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((String)uri.getUser());
                        boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((String)uri.getPass());
                        if (duplicateUsername || duplicatePassword) {
                            errorCollection.addError(REPOSITORY_GIT_REPOSITORY_URL, (duplicateUsername ? this.textProvider.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.textProvider.getText("repository.git.messages.duplicatePasswordField") : ""));
                        }
                        if (duplicateUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.duplicateUsernameField"));
                        }
                        if (duplicatePassword) {
                            errorCollection.addError(TEMPORARY_GIT_PASSWORD_CHANGE, this.textProvider.getText("repository.git.messages.duplicatePasswordField"));
                        }
                        if (uri.getHost() == null && hasUsername) {
                            errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.unsupportedUsernameField"));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block12;
                    errorCollection.addError(REPOSITORY_GIT_USERNAME, this.textProvider.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        if (buildConfiguration.getString(REPOSITORY_GIT_MAVEN_PATH, "").contains("..")) {
            errorCollection.addError(REPOSITORY_GIT_MAVEN_PATH, this.textProvider.getText("repository.git.messages.invalidPomPath"));
        }
        return errorCollection;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        HashMap variables = Maps.newHashMap();
        variables.put(REPOSITORY_GIT_REPOSITORY_URL, this.accessData.repositoryUrl);
        variables.put(REPOSITORY_GIT_BRANCH, this.accessData.branch);
        variables.put(REPOSITORY_GIT_USERNAME, this.accessData.username);
        return variables;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new GitMavenPomAccessor(this, this.sshProxyService, this.textProvider, this.getGitCapability()).withPath(this.pathToPom);
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Lists.transform(Arrays.asList(GitAuthenticationType.values()), (Function)new Function<GitAuthenticationType, NameValuePair>(){

            public NameValuePair apply(GitAuthenticationType from) {
                String typeName = from.name();
                return new NameValuePair(typeName, GitRepository.this.getAuthTypeName(typeName));
            }
        });
    }

    public String getAuthType() {
        return this.accessData.authenticationType != null ? this.accessData.authenticationType.name() : defaultAuthenticationType.name();
    }

    GitAuthenticationType safeParseAuthenticationType(String typeName) {
        if (typeName == null) {
            return defaultAuthenticationType;
        }
        try {
            return GitAuthenticationType.valueOf(typeName);
        }
        catch (IllegalArgumentException e) {
            return defaultAuthenticationType;
        }
    }

    String getAuthTypeName(String authType) {
        return this.textProvider.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    GitRepositoryAccessData getSubstitutedAccessData() {
        GitRepositoryAccessData substituted = new GitRepositoryAccessData();
        substituted.repositoryUrl = this.substituteString(this.accessData.repositoryUrl);
        substituted.branch = this.substituteString(this.accessData.branch);
        substituted.username = this.substituteString(this.accessData.username);
        substituted.password = ((StringEncrypter)this.encrypterRef.get()).decrypt(this.accessData.password);
        substituted.sshKey = ((StringEncrypter)this.encrypterRef.get()).decrypt(this.accessData.sshKey);
        substituted.sshPassphrase = ((StringEncrypter)this.encrypterRef.get()).decrypt(this.accessData.sshPassphrase);
        substituted.authenticationType = this.accessData.authenticationType;
        substituted.useShallowClones = this.accessData.useShallowClones;
        substituted.commandTimeout = this.accessData.commandTimeout;
        substituted.verboseLogs = this.accessData.verboseLogs;
        return substituted;
    }

    public boolean isUseShallowClones() {
        return this.accessData.useShallowClones;
    }

    public boolean isUseSubmodules() {
        return this.accessData.useSubmodules;
    }

    public String getRepositoryUrl() {
        return this.accessData.repositoryUrl;
    }

    public String getBranch() {
        return this.accessData.branch;
    }

    public int getCommandTimeout() {
        return this.accessData.commandTimeout;
    }

    public boolean getVerboseLogs() {
        return this.accessData.verboseLogs;
    }

    public String getAuthTypeName() {
        return this.getAuthTypeName(this.getAuthType());
    }

    public File getCacheDirectory() {
        return GitCacheDirectory.getCacheDirectory(this.buildDirectoryManager.getBaseBuildWorkingDirectory(), this.getSubstitutedAccessData());
    }

    public synchronized void setTextProvider(TextProvider textProvider) {
        super.setTextProvider(textProvider);
        if (textProvider.getText(REPOSITORY_GIT_NAME) == null) {
            LocalizedTextUtil.addDefaultResourceBundle((String)"com.atlassian.bamboo.plugins.git.i18n");
        }
    }

    public String getOptionDescription() {
        String capabilitiesLink = ServletActionContext.getRequest().getContextPath() + "/admin/agent/configureSharedLocalCapabilities.action";
        return this.textProvider.getText("repository.git.description", Arrays.asList(this.getGitCapability(), capabilitiesLink));
    }

    public Set<Requirement> getRequirements() {
        return Sets.newHashSet();
    }

    public boolean isGitExecutableSet() {
        return StringUtils.isNotBlank((String)this.getGitCapability());
    }

    @Nullable
    public String getGitCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable");
    }

    @Nullable
    public String getSshCapability() {
        return this.capabilityContext.getCapabilityValue("system.git.executable.ssh");
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    static class GitRepositoryAccessData
    implements Serializable {
        String repositoryUrl;
        String branch;
        String username;
        String password;
        String sshKey;
        String sshPassphrase;
        GitAuthenticationType authenticationType;
        boolean useShallowClones;
        boolean useSubmodules;
        int commandTimeout;
        boolean verboseLogs;
        transient ProxyRegistrationInfo proxyRegistrationInfo;

        GitRepositoryAccessData() {
        }

        GitRepositoryAccessData cloneAccessData() {
            GitRepositoryAccessData data = new GitRepositoryAccessData();
            data.repositoryUrl = this.repositoryUrl;
            data.branch = this.branch;
            data.username = this.username;
            data.password = this.password;
            data.sshKey = this.sshKey;
            data.sshPassphrase = this.sshPassphrase;
            data.authenticationType = this.authenticationType;
            data.useShallowClones = this.useShallowClones;
            data.useSubmodules = this.useSubmodules;
            data.commandTimeout = this.commandTimeout;
            data.verboseLogs = this.verboseLogs;
            return data;
        }
    }
}

