/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.NoFilepatternException;
import org.shaded.eclipse.jgit.dircache.DirCache;
import org.shaded.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.shaded.eclipse.jgit.dircache.DirCacheBuilder;
import org.shaded.eclipse.jgit.lib.FileMode;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.treewalk.TreeWalk;
import org.shaded.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    @Override
    public DirCache call() throws NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        try {
            try {
                dc = this.repo.lockDirCache();
                DirCacheBuilder builder = dc.builder();
                TreeWalk tw = new TreeWalk(this.repo);
                tw.reset();
                tw.setRecursive(true);
                tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
                tw.addTree(new DirCacheBuildIterator(builder));
                while (tw.next()) {
                    File path = new File(this.repo.getWorkTree(), tw.getPathString());
                    FileMode mode = tw.getFileMode(0);
                    if (mode.getObjectType() != 3) continue;
                    this.delete(path);
                }
                builder.commit();
                this.setCallable(false);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e);
            }
            Object var7_7 = null;
            if (dc != null) {
                dc.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (dc != null) {
                dc.unlock();
            }
            throw throwable;
        }
        return dc;
    }

    private void delete(File p) {
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            p = p.getParentFile();
        }
    }
}

