/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.NoHeadException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.shaded.eclipse.jgit.treewalk.filter.PathFilter;
import org.shaded.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.shaded.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    @Override
    public Iterable<RevCommit> call() throws NoHeadException, JGitInternalException {
        this.checkCallable();
        if (this.pathFilters.size() > 0) {
            this.walk.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(headId);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, e);
            }
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        return this.add(true, start);
    }

    public LogCommand not(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        return this.add(false, start);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        return this.not(since).add(until);
    }

    public LogCommand addPath(String path) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(path));
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start));
            }
            return this;
        }
        catch (MissingObjectException e) {
            throw e;
        }
        catch (IncorrectObjectTypeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start), e);
        }
    }
}

