/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.lib;

import java.io.IOException;
import org.shaded.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.shaded.eclipse.jgit.errors.MissingObjectException;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectInserter;
import org.shaded.eclipse.jgit.lib.ObjectLoader;
import org.shaded.eclipse.jgit.lib.ObjectReader;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(AnyObjectId objectId) throws IOException {
        ObjectReader or = this.newReader();
        try {
            boolean bl = or.has(objectId);
            return bl;
        }
        finally {
            or.release();
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectReader or = this.newReader();
        try {
            ObjectLoader objectLoader = or.open(objectId, typeHint);
            return objectLoader;
        }
        finally {
            or.release();
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

