/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.shaded.eclipse.jgit.JGitText;
import org.shaded.eclipse.jgit.api.Git;
import org.shaded.eclipse.jgit.api.GitCommand;
import org.shaded.eclipse.jgit.api.errors.GitAPIException;
import org.shaded.eclipse.jgit.api.errors.JGitInternalException;
import org.shaded.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.shaded.eclipse.jgit.api.errors.NoHeadException;
import org.shaded.eclipse.jgit.dircache.DirCacheCheckout;
import org.shaded.eclipse.jgit.lib.AnyObjectId;
import org.shaded.eclipse.jgit.lib.ObjectId;
import org.shaded.eclipse.jgit.lib.ObjectIdRef;
import org.shaded.eclipse.jgit.lib.Ref;
import org.shaded.eclipse.jgit.lib.Repository;
import org.shaded.eclipse.jgit.merge.MergeStrategy;
import org.shaded.eclipse.jgit.merge.ResolveMerger;
import org.shaded.eclipse.jgit.revwalk.RevCommit;
import org.shaded.eclipse.jgit.revwalk.RevWalk;
import org.shaded.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickCommand
extends GitCommand<RevCommit> {
    private List<Ref> commits = new LinkedList<Ref>();
    private List<Ref> cherryPickedRefs = new LinkedList<Ref>();

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    @Override
    public RevCommit call() throws GitAPIException {
        RevCommit newHead = null;
        this.checkCallable();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            RevCommit headCommit;
            Ref headRef = this.repo.getRef("HEAD");
            if (headRef == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
            for (Ref src : this.commits) {
                RevCommit srcCommit;
                ObjectId srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                    throw new MultipleParentsNotAllowedException(JGitText.get().canOnlyCherryPickCommitsWithOneParent);
                }
                RevCommit srcParent = srcCommit.getParent(0);
                revWalk.parseHeaders(srcParent);
                ResolveMerger merger = (ResolveMerger)MergeStrategy.RESOLVE.newMerger(this.repo);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                merger.setBase(srcParent.getTree());
                if (merger.merge(headCommit, srcCommit)) {
                    if (AnyObjectId.equals(headCommit.getTree().getId(), merger.getResultTreeId())) continue;
                } else {
                    RevCommit revCommit = null;
                    return revCommit;
                }
                DirCacheCheckout dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                dco.setFailOnConflict(true);
                dco.checkout();
                newHead = new Git(this.getRepository()).commit().setMessage(srcCommit.getFullMessage()).setAuthor(srcCommit.getAuthorIdent()).call();
                this.cherryPickedRefs.add(src);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
        finally {
            revWalk.release();
        }
        return newHead;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public List<Ref> getCherryPickedRefs() {
        return this.cherryPickedRefs;
    }
}

