/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.git.GitCommandProcessor;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.config.HomeLocator;
import com.opensymphony.xwork.TextProvider;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shaded.eclipse.jgit.storage.file.FileRepository;
import org.shaded.eclipse.jgit.transport.RefSpec;
import org.shaded.eclipse.jgit.transport.Transport;

public class NativeGitOperationHelper
extends GitOperationHelper {
    private static final Logger log = Logger.getLogger(NativeGitOperationHelper.class);
    private GitCommandProcessor gitCommandProcessor;

    public NativeGitOperationHelper(@NotNull GitRepository repository, @NotNull GitRepository.GitRepositoryAccessData accessData, @NotNull SshProxyService sshProxyService, @NotNull BuildLogger buildLogger, @NotNull TextProvider textProvider, @NotNull HomeLocator homeLocator, @Nullable String gitCapability) throws RepositoryException {
        super(buildLogger, sshProxyService, textProvider);
        this.gitCommandProcessor = new GitCommandProcessor(gitCapability, buildLogger, accessData.commandTimeout, accessData.verboseLogs);
        this.gitCommandProcessor.checkGitExistenceInSystem(repository.getWorkingDirectory());
        this.gitCommandProcessor.setSshCommand(repository.getSshCapability());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFetch(@NotNull Transport transport, @NotNull File sourceDirectory, @NotNull GitRepository.GitRepositoryAccessData accessData, RefSpec refSpec, boolean useShallow) throws RepositoryException {
        GitRepository.GitRepositoryAccessData proxiedAccessData = this.openProxy(accessData);
        try {
            this.gitCommandProcessor.runFetchCommand(sourceDirectory, proxiedAccessData, refSpec, useShallow);
        }
        finally {
            this.closeProxy(proxiedAccessData);
        }
    }

    @Override
    protected String doCheckout(@NotNull FileRepository localRepository, @NotNull File sourceDirectory, @NotNull String targetRevision, @Nullable String previousRevision, boolean useSubmodules) throws RepositoryException {
        this.gitCommandProcessor.runCheckoutCommand(sourceDirectory, targetRevision);
        if (useSubmodules) {
            this.gitCommandProcessor.runSubmoduleInitCommand(sourceDirectory);
            this.gitCommandProcessor.runSubmoduleUpdateCommand(sourceDirectory);
        }
        return targetRevision;
    }
}

